/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.tickets.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class UpdateTicketRequest {
    private final String ticketId;
    private final Optional<Map<String, Object>> ticketAttributes;
    private final Optional<String> ticketStateId;
    private final Optional<String> companyId;
    private final Optional<Boolean> open;
    private final Optional<Boolean> isShared;
    private final Optional<Integer> snoozedUntil;
    private final Optional<Integer> adminId;
    private final Optional<String> assigneeId;
    private final Map<String, Object> additionalProperties;

    private UpdateTicketRequest(String ticketId, Optional<Map<String, Object>> ticketAttributes, Optional<String> ticketStateId, Optional<String> companyId, Optional<Boolean> open, Optional<Boolean> isShared, Optional<Integer> snoozedUntil, Optional<Integer> adminId, Optional<String> assigneeId, Map<String, Object> additionalProperties) {
        this.ticketId = ticketId;
        this.ticketAttributes = ticketAttributes;
        this.ticketStateId = ticketStateId;
        this.companyId = companyId;
        this.open = open;
        this.isShared = isShared;
        this.snoozedUntil = snoozedUntil;
        this.adminId = adminId;
        this.assigneeId = assigneeId;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="ticket_id")
    public String getTicketId() {
        return this.ticketId;
    }

    @JsonProperty(value="ticket_attributes")
    public Optional<Map<String, Object>> getTicketAttributes() {
        return this.ticketAttributes;
    }

    @JsonProperty(value="ticket_state_id")
    public Optional<String> getTicketStateId() {
        return this.ticketStateId;
    }

    @JsonProperty(value="company_id")
    public Optional<String> getCompanyId() {
        return this.companyId;
    }

    @JsonProperty(value="open")
    public Optional<Boolean> getOpen() {
        return this.open;
    }

    @JsonProperty(value="is_shared")
    public Optional<Boolean> getIsShared() {
        return this.isShared;
    }

    @JsonProperty(value="snoozed_until")
    public Optional<Integer> getSnoozedUntil() {
        return this.snoozedUntil;
    }

    @JsonProperty(value="admin_id")
    public Optional<Integer> getAdminId() {
        return this.adminId;
    }

    @JsonProperty(value="assignee_id")
    public Optional<String> getAssigneeId() {
        return this.assigneeId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof UpdateTicketRequest && this.equalTo((UpdateTicketRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(UpdateTicketRequest other) {
        return this.ticketId.equals(other.ticketId) && this.ticketAttributes.equals(other.ticketAttributes) && this.ticketStateId.equals(other.ticketStateId) && this.companyId.equals(other.companyId) && this.open.equals(other.open) && this.isShared.equals(other.isShared) && this.snoozedUntil.equals(other.snoozedUntil) && this.adminId.equals(other.adminId) && this.assigneeId.equals(other.assigneeId);
    }

    public int hashCode() {
        return Objects.hash(this.ticketId, this.ticketAttributes, this.ticketStateId, this.companyId, this.open, this.isShared, this.snoozedUntil, this.adminId, this.assigneeId);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TicketIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements TicketIdStage,
    _FinalStage {
        private String ticketId;
        private Optional<String> assigneeId = Optional.empty();
        private Optional<Integer> adminId = Optional.empty();
        private Optional<Integer> snoozedUntil = Optional.empty();
        private Optional<Boolean> isShared = Optional.empty();
        private Optional<Boolean> open = Optional.empty();
        private Optional<String> companyId = Optional.empty();
        private Optional<String> ticketStateId = Optional.empty();
        private Optional<Map<String, Object>> ticketAttributes = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(UpdateTicketRequest other) {
            this.ticketId(other.getTicketId());
            this.ticketAttributes(other.getTicketAttributes());
            this.ticketStateId(other.getTicketStateId());
            this.companyId(other.getCompanyId());
            this.open(other.getOpen());
            this.isShared(other.getIsShared());
            this.snoozedUntil(other.getSnoozedUntil());
            this.adminId(other.getAdminId());
            this.assigneeId(other.getAssigneeId());
            return this;
        }

        @Override
        @JsonSetter(value="ticket_id")
        public _FinalStage ticketId(@NotNull String ticketId) {
            this.ticketId = Objects.requireNonNull(ticketId, "ticketId must not be null");
            return this;
        }

        @Override
        public _FinalStage assigneeId(String assigneeId) {
            this.assigneeId = Optional.ofNullable(assigneeId);
            return this;
        }

        @Override
        @JsonSetter(value="assignee_id", nulls=Nulls.SKIP)
        public _FinalStage assigneeId(Optional<String> assigneeId) {
            this.assigneeId = assigneeId;
            return this;
        }

        @Override
        public _FinalStage adminId(Integer adminId) {
            this.adminId = Optional.ofNullable(adminId);
            return this;
        }

        @Override
        @JsonSetter(value="admin_id", nulls=Nulls.SKIP)
        public _FinalStage adminId(Optional<Integer> adminId) {
            this.adminId = adminId;
            return this;
        }

        @Override
        public _FinalStage snoozedUntil(Integer snoozedUntil) {
            this.snoozedUntil = Optional.ofNullable(snoozedUntil);
            return this;
        }

        @Override
        @JsonSetter(value="snoozed_until", nulls=Nulls.SKIP)
        public _FinalStage snoozedUntil(Optional<Integer> snoozedUntil) {
            this.snoozedUntil = snoozedUntil;
            return this;
        }

        @Override
        public _FinalStage isShared(Boolean isShared) {
            this.isShared = Optional.ofNullable(isShared);
            return this;
        }

        @Override
        @JsonSetter(value="is_shared", nulls=Nulls.SKIP)
        public _FinalStage isShared(Optional<Boolean> isShared) {
            this.isShared = isShared;
            return this;
        }

        @Override
        public _FinalStage open(Boolean open) {
            this.open = Optional.ofNullable(open);
            return this;
        }

        @Override
        @JsonSetter(value="open", nulls=Nulls.SKIP)
        public _FinalStage open(Optional<Boolean> open) {
            this.open = open;
            return this;
        }

        @Override
        public _FinalStage companyId(String companyId) {
            this.companyId = Optional.ofNullable(companyId);
            return this;
        }

        @Override
        @JsonSetter(value="company_id", nulls=Nulls.SKIP)
        public _FinalStage companyId(Optional<String> companyId) {
            this.companyId = companyId;
            return this;
        }

        @Override
        public _FinalStage ticketStateId(String ticketStateId) {
            this.ticketStateId = Optional.ofNullable(ticketStateId);
            return this;
        }

        @Override
        @JsonSetter(value="ticket_state_id", nulls=Nulls.SKIP)
        public _FinalStage ticketStateId(Optional<String> ticketStateId) {
            this.ticketStateId = ticketStateId;
            return this;
        }

        @Override
        public _FinalStage ticketAttributes(Map<String, Object> ticketAttributes) {
            this.ticketAttributes = Optional.ofNullable(ticketAttributes);
            return this;
        }

        @Override
        @JsonSetter(value="ticket_attributes", nulls=Nulls.SKIP)
        public _FinalStage ticketAttributes(Optional<Map<String, Object>> ticketAttributes) {
            this.ticketAttributes = ticketAttributes;
            return this;
        }

        @Override
        public UpdateTicketRequest build() {
            return new UpdateTicketRequest(this.ticketId, this.ticketAttributes, this.ticketStateId, this.companyId, this.open, this.isShared, this.snoozedUntil, this.adminId, this.assigneeId, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public UpdateTicketRequest build();

        public _FinalStage ticketAttributes(Optional<Map<String, Object>> var1);

        public _FinalStage ticketAttributes(Map<String, Object> var1);

        public _FinalStage ticketStateId(Optional<String> var1);

        public _FinalStage ticketStateId(String var1);

        public _FinalStage companyId(Optional<String> var1);

        public _FinalStage companyId(String var1);

        public _FinalStage open(Optional<Boolean> var1);

        public _FinalStage open(Boolean var1);

        public _FinalStage isShared(Optional<Boolean> var1);

        public _FinalStage isShared(Boolean var1);

        public _FinalStage snoozedUntil(Optional<Integer> var1);

        public _FinalStage snoozedUntil(Integer var1);

        public _FinalStage adminId(Optional<Integer> var1);

        public _FinalStage adminId(Integer var1);

        public _FinalStage assigneeId(Optional<String> var1);

        public _FinalStage assigneeId(String var1);
    }

    public static interface TicketIdStage {
        public _FinalStage ticketId(@NotNull String var1);

        public Builder from(UpdateTicketRequest var1);
    }
}

