/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.tickets.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.resources.tickets.types.TicketContacts;
import com.intercom.api.resources.tickets.types.TicketState;
import com.intercom.api.resources.tickets.types.TicketType;
import com.intercom.api.types.LinkedObjectList;
import com.intercom.api.types.TicketParts;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class Ticket {
    private final String id;
    private final String ticketId;
    private final Category category;
    private final Map<String, Object> ticketAttributes;
    private final Optional<TicketState> ticketState;
    private final Optional<TicketType> ticketType;
    private final TicketContacts contacts;
    private final Optional<String> adminAssigneeId;
    private final Optional<String> teamAssigneeId;
    private final Optional<Integer> createdAt;
    private final Optional<Integer> updatedAt;
    private final Optional<Boolean> open;
    private final Optional<Integer> snoozedUntil;
    private final Optional<LinkedObjectList> linkedObjects;
    private final Optional<TicketParts> ticketParts;
    private final Optional<Boolean> isShared;
    private final Map<String, Object> additionalProperties;

    private Ticket(String id, String ticketId, Category category, Map<String, Object> ticketAttributes, Optional<TicketState> ticketState, Optional<TicketType> ticketType, TicketContacts contacts, Optional<String> adminAssigneeId, Optional<String> teamAssigneeId, Optional<Integer> createdAt, Optional<Integer> updatedAt, Optional<Boolean> open, Optional<Integer> snoozedUntil, Optional<LinkedObjectList> linkedObjects, Optional<TicketParts> ticketParts, Optional<Boolean> isShared, Map<String, Object> additionalProperties) {
        this.id = id;
        this.ticketId = ticketId;
        this.category = category;
        this.ticketAttributes = ticketAttributes;
        this.ticketState = ticketState;
        this.ticketType = ticketType;
        this.contacts = contacts;
        this.adminAssigneeId = adminAssigneeId;
        this.teamAssigneeId = teamAssigneeId;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.open = open;
        this.snoozedUntil = snoozedUntil;
        this.linkedObjects = linkedObjects;
        this.ticketParts = ticketParts;
        this.isShared = isShared;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="type")
    public String getType() {
        return "ticket";
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="ticket_id")
    public String getTicketId() {
        return this.ticketId;
    }

    @JsonProperty(value="category")
    public Category getCategory() {
        return this.category;
    }

    @JsonProperty(value="ticket_attributes")
    public Map<String, Object> getTicketAttributes() {
        return this.ticketAttributes;
    }

    @JsonProperty(value="ticket_state")
    public Optional<TicketState> getTicketState() {
        return this.ticketState;
    }

    @JsonProperty(value="ticket_type")
    public Optional<TicketType> getTicketType() {
        return this.ticketType;
    }

    @JsonProperty(value="contacts")
    public TicketContacts getContacts() {
        return this.contacts;
    }

    @JsonProperty(value="admin_assignee_id")
    public Optional<String> getAdminAssigneeId() {
        return this.adminAssigneeId;
    }

    @JsonProperty(value="team_assignee_id")
    public Optional<String> getTeamAssigneeId() {
        return this.teamAssigneeId;
    }

    @JsonProperty(value="created_at")
    public Optional<Integer> getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="updated_at")
    public Optional<Integer> getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonProperty(value="open")
    public Optional<Boolean> getOpen() {
        return this.open;
    }

    @JsonProperty(value="snoozed_until")
    public Optional<Integer> getSnoozedUntil() {
        return this.snoozedUntil;
    }

    @JsonProperty(value="linked_objects")
    public Optional<LinkedObjectList> getLinkedObjects() {
        return this.linkedObjects;
    }

    @JsonProperty(value="ticket_parts")
    public Optional<TicketParts> getTicketParts() {
        return this.ticketParts;
    }

    @JsonProperty(value="is_shared")
    public Optional<Boolean> getIsShared() {
        return this.isShared;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof Ticket && this.equalTo((Ticket)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(Ticket other) {
        return this.id.equals(other.id) && this.ticketId.equals(other.ticketId) && this.category.equals(other.category) && this.ticketAttributes.equals(other.ticketAttributes) && this.ticketState.equals(other.ticketState) && this.ticketType.equals(other.ticketType) && this.contacts.equals(other.contacts) && this.adminAssigneeId.equals(other.adminAssigneeId) && this.teamAssigneeId.equals(other.teamAssigneeId) && this.createdAt.equals(other.createdAt) && this.updatedAt.equals(other.updatedAt) && this.open.equals(other.open) && this.snoozedUntil.equals(other.snoozedUntil) && this.linkedObjects.equals(other.linkedObjects) && this.ticketParts.equals(other.ticketParts) && this.isShared.equals(other.isShared);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.ticketId, this.category, this.ticketAttributes, this.ticketState, this.ticketType, this.contacts, this.adminAssigneeId, this.teamAssigneeId, this.createdAt, this.updatedAt, this.open, this.snoozedUntil, this.linkedObjects, this.ticketParts, this.isShared);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    public static final class Category {
        public static final Category BACK_OFFICE = new Category(Value.BACK_OFFICE, "Back-office");
        public static final Category CUSTOMER = new Category(Value.CUSTOMER, "Customer");
        public static final Category TRACKER = new Category(Value.TRACKER, "Tracker");
        private final Value value;
        private final String string;

        Category(Value value, String string) {
            this.value = value;
            this.string = string;
        }

        public Value getEnumValue() {
            return this.value;
        }

        @JsonValue
        public String toString() {
            return this.string;
        }

        public boolean equals(Object other) {
            return this == other || other instanceof Category && this.string.equals(((Category)other).string);
        }

        public int hashCode() {
            return this.string.hashCode();
        }

        public <T> T visit(Visitor<T> visitor) {
            switch (this.value) {
                case BACK_OFFICE: {
                    return visitor.visitBackOffice();
                }
                case CUSTOMER: {
                    return visitor.visitCustomer();
                }
                case TRACKER: {
                    return visitor.visitTracker();
                }
            }
            return visitor.visitUnknown(this.string);
        }

        @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
        public static Category valueOf(String value) {
            switch (value) {
                case "Back-office": {
                    return BACK_OFFICE;
                }
                case "Customer": {
                    return CUSTOMER;
                }
                case "Tracker": {
                    return TRACKER;
                }
            }
            return new Category(Value.UNKNOWN, value);
        }

        public static interface Visitor<T> {
            public T visitCustomer();

            public T visitBackOffice();

            public T visitTracker();

            public T visitUnknown(String var1);
        }

        public static enum Value {
            CUSTOMER,
            BACK_OFFICE,
            TRACKER,
            UNKNOWN;

        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements IdStage,
    TicketIdStage,
    CategoryStage,
    ContactsStage,
    _FinalStage {
        private String id;
        private String ticketId;
        private Category category;
        private TicketContacts contacts;
        private Optional<Boolean> isShared = Optional.empty();
        private Optional<TicketParts> ticketParts = Optional.empty();
        private Optional<LinkedObjectList> linkedObjects = Optional.empty();
        private Optional<Integer> snoozedUntil = Optional.empty();
        private Optional<Boolean> open = Optional.empty();
        private Optional<Integer> updatedAt = Optional.empty();
        private Optional<Integer> createdAt = Optional.empty();
        private Optional<String> teamAssigneeId = Optional.empty();
        private Optional<String> adminAssigneeId = Optional.empty();
        private Optional<TicketType> ticketType = Optional.empty();
        private Optional<TicketState> ticketState = Optional.empty();
        private Map<String, Object> ticketAttributes = new LinkedHashMap<String, Object>();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(Ticket other) {
            this.id(other.getId());
            this.ticketId(other.getTicketId());
            this.category(other.getCategory());
            this.ticketAttributes(other.getTicketAttributes());
            this.ticketState(other.getTicketState());
            this.ticketType(other.getTicketType());
            this.contacts(other.getContacts());
            this.adminAssigneeId(other.getAdminAssigneeId());
            this.teamAssigneeId(other.getTeamAssigneeId());
            this.createdAt(other.getCreatedAt());
            this.updatedAt(other.getUpdatedAt());
            this.open(other.getOpen());
            this.snoozedUntil(other.getSnoozedUntil());
            this.linkedObjects(other.getLinkedObjects());
            this.ticketParts(other.getTicketParts());
            this.isShared(other.getIsShared());
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public TicketIdStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="ticket_id")
        public CategoryStage ticketId(@NotNull String ticketId) {
            this.ticketId = Objects.requireNonNull(ticketId, "ticketId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="category")
        public ContactsStage category(@NotNull Category category) {
            this.category = Objects.requireNonNull(category, "category must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="contacts")
        public _FinalStage contacts(@NotNull TicketContacts contacts) {
            this.contacts = Objects.requireNonNull(contacts, "contacts must not be null");
            return this;
        }

        @Override
        public _FinalStage isShared(Boolean isShared) {
            this.isShared = Optional.ofNullable(isShared);
            return this;
        }

        @Override
        @JsonSetter(value="is_shared", nulls=Nulls.SKIP)
        public _FinalStage isShared(Optional<Boolean> isShared) {
            this.isShared = isShared;
            return this;
        }

        @Override
        public _FinalStage ticketParts(TicketParts ticketParts) {
            this.ticketParts = Optional.ofNullable(ticketParts);
            return this;
        }

        @Override
        @JsonSetter(value="ticket_parts", nulls=Nulls.SKIP)
        public _FinalStage ticketParts(Optional<TicketParts> ticketParts) {
            this.ticketParts = ticketParts;
            return this;
        }

        @Override
        public _FinalStage linkedObjects(LinkedObjectList linkedObjects) {
            this.linkedObjects = Optional.ofNullable(linkedObjects);
            return this;
        }

        @Override
        @JsonSetter(value="linked_objects", nulls=Nulls.SKIP)
        public _FinalStage linkedObjects(Optional<LinkedObjectList> linkedObjects) {
            this.linkedObjects = linkedObjects;
            return this;
        }

        @Override
        public _FinalStage snoozedUntil(Integer snoozedUntil) {
            this.snoozedUntil = Optional.ofNullable(snoozedUntil);
            return this;
        }

        @Override
        @JsonSetter(value="snoozed_until", nulls=Nulls.SKIP)
        public _FinalStage snoozedUntil(Optional<Integer> snoozedUntil) {
            this.snoozedUntil = snoozedUntil;
            return this;
        }

        @Override
        public _FinalStage open(Boolean open) {
            this.open = Optional.ofNullable(open);
            return this;
        }

        @Override
        @JsonSetter(value="open", nulls=Nulls.SKIP)
        public _FinalStage open(Optional<Boolean> open) {
            this.open = open;
            return this;
        }

        @Override
        public _FinalStage updatedAt(Integer updatedAt) {
            this.updatedAt = Optional.ofNullable(updatedAt);
            return this;
        }

        @Override
        @JsonSetter(value="updated_at", nulls=Nulls.SKIP)
        public _FinalStage updatedAt(Optional<Integer> updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Override
        public _FinalStage createdAt(Integer createdAt) {
            this.createdAt = Optional.ofNullable(createdAt);
            return this;
        }

        @Override
        @JsonSetter(value="created_at", nulls=Nulls.SKIP)
        public _FinalStage createdAt(Optional<Integer> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        @Override
        public _FinalStage teamAssigneeId(String teamAssigneeId) {
            this.teamAssigneeId = Optional.ofNullable(teamAssigneeId);
            return this;
        }

        @Override
        @JsonSetter(value="team_assignee_id", nulls=Nulls.SKIP)
        public _FinalStage teamAssigneeId(Optional<String> teamAssigneeId) {
            this.teamAssigneeId = teamAssigneeId;
            return this;
        }

        @Override
        public _FinalStage adminAssigneeId(String adminAssigneeId) {
            this.adminAssigneeId = Optional.ofNullable(adminAssigneeId);
            return this;
        }

        @Override
        @JsonSetter(value="admin_assignee_id", nulls=Nulls.SKIP)
        public _FinalStage adminAssigneeId(Optional<String> adminAssigneeId) {
            this.adminAssigneeId = adminAssigneeId;
            return this;
        }

        @Override
        public _FinalStage ticketType(TicketType ticketType) {
            this.ticketType = Optional.ofNullable(ticketType);
            return this;
        }

        @Override
        @JsonSetter(value="ticket_type", nulls=Nulls.SKIP)
        public _FinalStage ticketType(Optional<TicketType> ticketType) {
            this.ticketType = ticketType;
            return this;
        }

        @Override
        public _FinalStage ticketState(TicketState ticketState) {
            this.ticketState = Optional.ofNullable(ticketState);
            return this;
        }

        @Override
        @JsonSetter(value="ticket_state", nulls=Nulls.SKIP)
        public _FinalStage ticketState(Optional<TicketState> ticketState) {
            this.ticketState = ticketState;
            return this;
        }

        @Override
        public _FinalStage ticketAttributes(String key, Object value) {
            this.ticketAttributes.put(key, value);
            return this;
        }

        @Override
        public _FinalStage putAllTicketAttributes(Map<String, Object> ticketAttributes) {
            if (ticketAttributes != null) {
                this.ticketAttributes.putAll(ticketAttributes);
            }
            return this;
        }

        @Override
        @JsonSetter(value="ticket_attributes", nulls=Nulls.SKIP)
        public _FinalStage ticketAttributes(Map<String, Object> ticketAttributes) {
            this.ticketAttributes.clear();
            if (ticketAttributes != null) {
                this.ticketAttributes.putAll(ticketAttributes);
            }
            return this;
        }

        @Override
        public Ticket build() {
            return new Ticket(this.id, this.ticketId, this.category, this.ticketAttributes, this.ticketState, this.ticketType, this.contacts, this.adminAssigneeId, this.teamAssigneeId, this.createdAt, this.updatedAt, this.open, this.snoozedUntil, this.linkedObjects, this.ticketParts, this.isShared, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public Ticket build();

        public _FinalStage ticketAttributes(Map<String, Object> var1);

        public _FinalStage putAllTicketAttributes(Map<String, Object> var1);

        public _FinalStage ticketAttributes(String var1, Object var2);

        public _FinalStage ticketState(Optional<TicketState> var1);

        public _FinalStage ticketState(TicketState var1);

        public _FinalStage ticketType(Optional<TicketType> var1);

        public _FinalStage ticketType(TicketType var1);

        public _FinalStage adminAssigneeId(Optional<String> var1);

        public _FinalStage adminAssigneeId(String var1);

        public _FinalStage teamAssigneeId(Optional<String> var1);

        public _FinalStage teamAssigneeId(String var1);

        public _FinalStage createdAt(Optional<Integer> var1);

        public _FinalStage createdAt(Integer var1);

        public _FinalStage updatedAt(Optional<Integer> var1);

        public _FinalStage updatedAt(Integer var1);

        public _FinalStage open(Optional<Boolean> var1);

        public _FinalStage open(Boolean var1);

        public _FinalStage snoozedUntil(Optional<Integer> var1);

        public _FinalStage snoozedUntil(Integer var1);

        public _FinalStage linkedObjects(Optional<LinkedObjectList> var1);

        public _FinalStage linkedObjects(LinkedObjectList var1);

        public _FinalStage ticketParts(Optional<TicketParts> var1);

        public _FinalStage ticketParts(TicketParts var1);

        public _FinalStage isShared(Optional<Boolean> var1);

        public _FinalStage isShared(Boolean var1);
    }

    public static interface ContactsStage {
        public _FinalStage contacts(@NotNull TicketContacts var1);
    }

    public static interface CategoryStage {
        public ContactsStage category(@NotNull Category var1);
    }

    public static interface TicketIdStage {
        public CategoryStage ticketId(@NotNull String var1);
    }

    public static interface IdStage {
        public TicketIdStage id(@NotNull String var1);

        public Builder from(Ticket var1);
    }
}

