/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.tickettypes.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class UpdateTicketTypeRequest {
    private final String ticketTypeId;
    private final Optional<String> name;
    private final Optional<String> description;
    private final Optional<Category> category;
    private final Optional<String> icon;
    private final Optional<Boolean> archived;
    private final Optional<Boolean> isInternal;
    private final Map<String, Object> additionalProperties;

    private UpdateTicketTypeRequest(String ticketTypeId, Optional<String> name, Optional<String> description, Optional<Category> category, Optional<String> icon, Optional<Boolean> archived, Optional<Boolean> isInternal, Map<String, Object> additionalProperties) {
        this.ticketTypeId = ticketTypeId;
        this.name = name;
        this.description = description;
        this.category = category;
        this.icon = icon;
        this.archived = archived;
        this.isInternal = isInternal;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="ticket_type_id")
    public String getTicketTypeId() {
        return this.ticketTypeId;
    }

    @JsonProperty(value="name")
    public Optional<String> getName() {
        return this.name;
    }

    @JsonProperty(value="description")
    public Optional<String> getDescription() {
        return this.description;
    }

    @JsonProperty(value="category")
    public Optional<Category> getCategory() {
        return this.category;
    }

    @JsonProperty(value="icon")
    public Optional<String> getIcon() {
        return this.icon;
    }

    @JsonProperty(value="archived")
    public Optional<Boolean> getArchived() {
        return this.archived;
    }

    @JsonProperty(value="is_internal")
    public Optional<Boolean> getIsInternal() {
        return this.isInternal;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof UpdateTicketTypeRequest && this.equalTo((UpdateTicketTypeRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(UpdateTicketTypeRequest other) {
        return this.ticketTypeId.equals(other.ticketTypeId) && this.name.equals(other.name) && this.description.equals(other.description) && this.category.equals(other.category) && this.icon.equals(other.icon) && this.archived.equals(other.archived) && this.isInternal.equals(other.isInternal);
    }

    public int hashCode() {
        return Objects.hash(this.ticketTypeId, this.name, this.description, this.category, this.icon, this.archived, this.isInternal);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TicketTypeIdStage builder() {
        return new Builder();
    }

    public static final class Category {
        public static final Category BACK_OFFICE = new Category(Value.BACK_OFFICE, "Back-office");
        public static final Category CUSTOMER = new Category(Value.CUSTOMER, "Customer");
        public static final Category TRACKER = new Category(Value.TRACKER, "Tracker");
        private final Value value;
        private final String string;

        Category(Value value, String string) {
            this.value = value;
            this.string = string;
        }

        public Value getEnumValue() {
            return this.value;
        }

        @JsonValue
        public String toString() {
            return this.string;
        }

        public boolean equals(Object other) {
            return this == other || other instanceof Category && this.string.equals(((Category)other).string);
        }

        public int hashCode() {
            return this.string.hashCode();
        }

        public <T> T visit(Visitor<T> visitor) {
            switch (this.value) {
                case BACK_OFFICE: {
                    return visitor.visitBackOffice();
                }
                case CUSTOMER: {
                    return visitor.visitCustomer();
                }
                case TRACKER: {
                    return visitor.visitTracker();
                }
            }
            return visitor.visitUnknown(this.string);
        }

        @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
        public static Category valueOf(String value) {
            switch (value) {
                case "Back-office": {
                    return BACK_OFFICE;
                }
                case "Customer": {
                    return CUSTOMER;
                }
                case "Tracker": {
                    return TRACKER;
                }
            }
            return new Category(Value.UNKNOWN, value);
        }

        public static interface Visitor<T> {
            public T visitCustomer();

            public T visitBackOffice();

            public T visitTracker();

            public T visitUnknown(String var1);
        }

        public static enum Value {
            CUSTOMER,
            BACK_OFFICE,
            TRACKER,
            UNKNOWN;

        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements TicketTypeIdStage,
    _FinalStage {
        private String ticketTypeId;
        private Optional<Boolean> isInternal = Optional.empty();
        private Optional<Boolean> archived = Optional.empty();
        private Optional<String> icon = Optional.empty();
        private Optional<Category> category = Optional.empty();
        private Optional<String> description = Optional.empty();
        private Optional<String> name = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(UpdateTicketTypeRequest other) {
            this.ticketTypeId(other.getTicketTypeId());
            this.name(other.getName());
            this.description(other.getDescription());
            this.category(other.getCategory());
            this.icon(other.getIcon());
            this.archived(other.getArchived());
            this.isInternal(other.getIsInternal());
            return this;
        }

        @Override
        @JsonSetter(value="ticket_type_id")
        public _FinalStage ticketTypeId(@NotNull String ticketTypeId) {
            this.ticketTypeId = Objects.requireNonNull(ticketTypeId, "ticketTypeId must not be null");
            return this;
        }

        @Override
        public _FinalStage isInternal(Boolean isInternal) {
            this.isInternal = Optional.ofNullable(isInternal);
            return this;
        }

        @Override
        @JsonSetter(value="is_internal", nulls=Nulls.SKIP)
        public _FinalStage isInternal(Optional<Boolean> isInternal) {
            this.isInternal = isInternal;
            return this;
        }

        @Override
        public _FinalStage archived(Boolean archived) {
            this.archived = Optional.ofNullable(archived);
            return this;
        }

        @Override
        @JsonSetter(value="archived", nulls=Nulls.SKIP)
        public _FinalStage archived(Optional<Boolean> archived) {
            this.archived = archived;
            return this;
        }

        @Override
        public _FinalStage icon(String icon) {
            this.icon = Optional.ofNullable(icon);
            return this;
        }

        @Override
        @JsonSetter(value="icon", nulls=Nulls.SKIP)
        public _FinalStage icon(Optional<String> icon) {
            this.icon = icon;
            return this;
        }

        @Override
        public _FinalStage category(Category category) {
            this.category = Optional.ofNullable(category);
            return this;
        }

        @Override
        @JsonSetter(value="category", nulls=Nulls.SKIP)
        public _FinalStage category(Optional<Category> category) {
            this.category = category;
            return this;
        }

        @Override
        public _FinalStage description(String description) {
            this.description = Optional.ofNullable(description);
            return this;
        }

        @Override
        @JsonSetter(value="description", nulls=Nulls.SKIP)
        public _FinalStage description(Optional<String> description) {
            this.description = description;
            return this;
        }

        @Override
        public _FinalStage name(String name) {
            this.name = Optional.ofNullable(name);
            return this;
        }

        @Override
        @JsonSetter(value="name", nulls=Nulls.SKIP)
        public _FinalStage name(Optional<String> name) {
            this.name = name;
            return this;
        }

        @Override
        public UpdateTicketTypeRequest build() {
            return new UpdateTicketTypeRequest(this.ticketTypeId, this.name, this.description, this.category, this.icon, this.archived, this.isInternal, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public UpdateTicketTypeRequest build();

        public _FinalStage name(Optional<String> var1);

        public _FinalStage name(String var1);

        public _FinalStage description(Optional<String> var1);

        public _FinalStage description(String var1);

        public _FinalStage category(Optional<Category> var1);

        public _FinalStage category(Category var1);

        public _FinalStage icon(Optional<String> var1);

        public _FinalStage icon(String var1);

        public _FinalStage archived(Optional<Boolean> var1);

        public _FinalStage archived(Boolean var1);

        public _FinalStage isInternal(Optional<Boolean> var1);

        public _FinalStage isInternal(Boolean var1);
    }

    public static interface TicketTypeIdStage {
        public _FinalStage ticketTypeId(@NotNull String var1);

        public Builder from(UpdateTicketTypeRequest var1);
    }
}

