/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.unstable.dataattributes.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class DataAttribute {
    private final Optional<String> type;
    private final Optional<Integer> id;
    private final Optional<Model> model;
    private final Optional<String> name;
    private final Optional<String> fullName;
    private final Optional<String> label;
    private final Optional<String> description;
    private final Optional<DataType> dataType;
    private final Optional<List<String>> options;
    private final Optional<Boolean> apiWritable;
    private final Optional<Boolean> messengerWritable;
    private final Optional<Boolean> uiWritable;
    private final Optional<Boolean> custom;
    private final Optional<Boolean> archived;
    private final Optional<Integer> createdAt;
    private final Optional<Integer> updatedAt;
    private final Optional<String> adminId;
    private final Map<String, Object> additionalProperties;

    private DataAttribute(Optional<String> type, Optional<Integer> id, Optional<Model> model, Optional<String> name, Optional<String> fullName, Optional<String> label, Optional<String> description, Optional<DataType> dataType, Optional<List<String>> options, Optional<Boolean> apiWritable, Optional<Boolean> messengerWritable, Optional<Boolean> uiWritable, Optional<Boolean> custom, Optional<Boolean> archived, Optional<Integer> createdAt, Optional<Integer> updatedAt, Optional<String> adminId, Map<String, Object> additionalProperties) {
        this.type = type;
        this.id = id;
        this.model = model;
        this.name = name;
        this.fullName = fullName;
        this.label = label;
        this.description = description;
        this.dataType = dataType;
        this.options = options;
        this.apiWritable = apiWritable;
        this.messengerWritable = messengerWritable;
        this.uiWritable = uiWritable;
        this.custom = custom;
        this.archived = archived;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.adminId = adminId;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="type")
    public Optional<String> getType() {
        return this.type;
    }

    @JsonProperty(value="id")
    public Optional<Integer> getId() {
        return this.id;
    }

    @JsonProperty(value="model")
    public Optional<Model> getModel() {
        return this.model;
    }

    @JsonProperty(value="name")
    public Optional<String> getName() {
        return this.name;
    }

    @JsonProperty(value="full_name")
    public Optional<String> getFullName() {
        return this.fullName;
    }

    @JsonProperty(value="label")
    public Optional<String> getLabel() {
        return this.label;
    }

    @JsonProperty(value="description")
    public Optional<String> getDescription() {
        return this.description;
    }

    @JsonProperty(value="data_type")
    public Optional<DataType> getDataType() {
        return this.dataType;
    }

    @JsonProperty(value="options")
    public Optional<List<String>> getOptions() {
        return this.options;
    }

    @JsonProperty(value="api_writable")
    public Optional<Boolean> getApiWritable() {
        return this.apiWritable;
    }

    @JsonProperty(value="messenger_writable")
    public Optional<Boolean> getMessengerWritable() {
        return this.messengerWritable;
    }

    @JsonProperty(value="ui_writable")
    public Optional<Boolean> getUiWritable() {
        return this.uiWritable;
    }

    @JsonProperty(value="custom")
    public Optional<Boolean> getCustom() {
        return this.custom;
    }

    @JsonProperty(value="archived")
    public Optional<Boolean> getArchived() {
        return this.archived;
    }

    @JsonProperty(value="created_at")
    public Optional<Integer> getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="updated_at")
    public Optional<Integer> getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonProperty(value="admin_id")
    public Optional<String> getAdminId() {
        return this.adminId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof DataAttribute && this.equalTo((DataAttribute)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(DataAttribute other) {
        return this.type.equals(other.type) && this.id.equals(other.id) && this.model.equals(other.model) && this.name.equals(other.name) && this.fullName.equals(other.fullName) && this.label.equals(other.label) && this.description.equals(other.description) && this.dataType.equals(other.dataType) && this.options.equals(other.options) && this.apiWritable.equals(other.apiWritable) && this.messengerWritable.equals(other.messengerWritable) && this.uiWritable.equals(other.uiWritable) && this.custom.equals(other.custom) && this.archived.equals(other.archived) && this.createdAt.equals(other.createdAt) && this.updatedAt.equals(other.updatedAt) && this.adminId.equals(other.adminId);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.id, this.model, this.name, this.fullName, this.label, this.description, this.dataType, this.options, this.apiWritable, this.messengerWritable, this.uiWritable, this.custom, this.archived, this.createdAt, this.updatedAt, this.adminId);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Model {
        public static final Model CONTACT = new Model(Value.CONTACT, "contact");
        public static final Model COMPANY = new Model(Value.COMPANY, "company");
        private final Value value;
        private final String string;

        Model(Value value, String string) {
            this.value = value;
            this.string = string;
        }

        public Value getEnumValue() {
            return this.value;
        }

        @JsonValue
        public String toString() {
            return this.string;
        }

        public boolean equals(Object other) {
            return this == other || other instanceof Model && this.string.equals(((Model)other).string);
        }

        public int hashCode() {
            return this.string.hashCode();
        }

        public <T> T visit(Visitor<T> visitor) {
            switch (this.value) {
                case CONTACT: {
                    return visitor.visitContact();
                }
                case COMPANY: {
                    return visitor.visitCompany();
                }
            }
            return visitor.visitUnknown(this.string);
        }

        @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
        public static Model valueOf(String value) {
            switch (value) {
                case "contact": {
                    return CONTACT;
                }
                case "company": {
                    return COMPANY;
                }
            }
            return new Model(Value.UNKNOWN, value);
        }

        public static interface Visitor<T> {
            public T visitContact();

            public T visitCompany();

            public T visitUnknown(String var1);
        }

        public static enum Value {
            CONTACT,
            COMPANY,
            UNKNOWN;

        }
    }

    public static final class DataType {
        public static final DataType STRING = new DataType(Value.STRING, "string");
        public static final DataType FLOAT = new DataType(Value.FLOAT, "float");
        public static final DataType INTEGER = new DataType(Value.INTEGER, "integer");
        public static final DataType BOOLEAN = new DataType(Value.BOOLEAN, "boolean");
        public static final DataType DATE = new DataType(Value.DATE, "date");
        private final Value value;
        private final String string;

        DataType(Value value, String string) {
            this.value = value;
            this.string = string;
        }

        public Value getEnumValue() {
            return this.value;
        }

        @JsonValue
        public String toString() {
            return this.string;
        }

        public boolean equals(Object other) {
            return this == other || other instanceof DataType && this.string.equals(((DataType)other).string);
        }

        public int hashCode() {
            return this.string.hashCode();
        }

        public <T> T visit(Visitor<T> visitor) {
            switch (this.value) {
                case STRING: {
                    return visitor.visitString();
                }
                case FLOAT: {
                    return visitor.visitFloat();
                }
                case INTEGER: {
                    return visitor.visitInteger();
                }
                case BOOLEAN: {
                    return visitor.visitBoolean();
                }
                case DATE: {
                    return visitor.visitDate();
                }
            }
            return visitor.visitUnknown(this.string);
        }

        @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
        public static DataType valueOf(String value) {
            switch (value) {
                case "string": {
                    return STRING;
                }
                case "float": {
                    return FLOAT;
                }
                case "integer": {
                    return INTEGER;
                }
                case "boolean": {
                    return BOOLEAN;
                }
                case "date": {
                    return DATE;
                }
            }
            return new DataType(Value.UNKNOWN, value);
        }

        public static interface Visitor<T> {
            public T visitString();

            public T visitInteger();

            public T visitFloat();

            public T visitBoolean();

            public T visitDate();

            public T visitUnknown(String var1);
        }

        public static enum Value {
            STRING,
            INTEGER,
            FLOAT,
            BOOLEAN,
            DATE,
            UNKNOWN;

        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> type = Optional.empty();
        private Optional<Integer> id = Optional.empty();
        private Optional<Model> model = Optional.empty();
        private Optional<String> name = Optional.empty();
        private Optional<String> fullName = Optional.empty();
        private Optional<String> label = Optional.empty();
        private Optional<String> description = Optional.empty();
        private Optional<DataType> dataType = Optional.empty();
        private Optional<List<String>> options = Optional.empty();
        private Optional<Boolean> apiWritable = Optional.empty();
        private Optional<Boolean> messengerWritable = Optional.empty();
        private Optional<Boolean> uiWritable = Optional.empty();
        private Optional<Boolean> custom = Optional.empty();
        private Optional<Boolean> archived = Optional.empty();
        private Optional<Integer> createdAt = Optional.empty();
        private Optional<Integer> updatedAt = Optional.empty();
        private Optional<String> adminId = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(DataAttribute other) {
            this.type(other.getType());
            this.id(other.getId());
            this.model(other.getModel());
            this.name(other.getName());
            this.fullName(other.getFullName());
            this.label(other.getLabel());
            this.description(other.getDescription());
            this.dataType(other.getDataType());
            this.options(other.getOptions());
            this.apiWritable(other.getApiWritable());
            this.messengerWritable(other.getMessengerWritable());
            this.uiWritable(other.getUiWritable());
            this.custom(other.getCustom());
            this.archived(other.getArchived());
            this.createdAt(other.getCreatedAt());
            this.updatedAt(other.getUpdatedAt());
            this.adminId(other.getAdminId());
            return this;
        }

        @JsonSetter(value="type", nulls=Nulls.SKIP)
        public Builder type(Optional<String> type) {
            this.type = type;
            return this;
        }

        public Builder type(String type) {
            this.type = Optional.ofNullable(type);
            return this;
        }

        @JsonSetter(value="id", nulls=Nulls.SKIP)
        public Builder id(Optional<Integer> id) {
            this.id = id;
            return this;
        }

        public Builder id(Integer id) {
            this.id = Optional.ofNullable(id);
            return this;
        }

        @JsonSetter(value="model", nulls=Nulls.SKIP)
        public Builder model(Optional<Model> model) {
            this.model = model;
            return this;
        }

        public Builder model(Model model) {
            this.model = Optional.ofNullable(model);
            return this;
        }

        @JsonSetter(value="name", nulls=Nulls.SKIP)
        public Builder name(Optional<String> name) {
            this.name = name;
            return this;
        }

        public Builder name(String name) {
            this.name = Optional.ofNullable(name);
            return this;
        }

        @JsonSetter(value="full_name", nulls=Nulls.SKIP)
        public Builder fullName(Optional<String> fullName) {
            this.fullName = fullName;
            return this;
        }

        public Builder fullName(String fullName) {
            this.fullName = Optional.ofNullable(fullName);
            return this;
        }

        @JsonSetter(value="label", nulls=Nulls.SKIP)
        public Builder label(Optional<String> label) {
            this.label = label;
            return this;
        }

        public Builder label(String label) {
            this.label = Optional.ofNullable(label);
            return this;
        }

        @JsonSetter(value="description", nulls=Nulls.SKIP)
        public Builder description(Optional<String> description) {
            this.description = description;
            return this;
        }

        public Builder description(String description) {
            this.description = Optional.ofNullable(description);
            return this;
        }

        @JsonSetter(value="data_type", nulls=Nulls.SKIP)
        public Builder dataType(Optional<DataType> dataType) {
            this.dataType = dataType;
            return this;
        }

        public Builder dataType(DataType dataType) {
            this.dataType = Optional.ofNullable(dataType);
            return this;
        }

        @JsonSetter(value="options", nulls=Nulls.SKIP)
        public Builder options(Optional<List<String>> options) {
            this.options = options;
            return this;
        }

        public Builder options(List<String> options) {
            this.options = Optional.ofNullable(options);
            return this;
        }

        @JsonSetter(value="api_writable", nulls=Nulls.SKIP)
        public Builder apiWritable(Optional<Boolean> apiWritable) {
            this.apiWritable = apiWritable;
            return this;
        }

        public Builder apiWritable(Boolean apiWritable) {
            this.apiWritable = Optional.ofNullable(apiWritable);
            return this;
        }

        @JsonSetter(value="messenger_writable", nulls=Nulls.SKIP)
        public Builder messengerWritable(Optional<Boolean> messengerWritable) {
            this.messengerWritable = messengerWritable;
            return this;
        }

        public Builder messengerWritable(Boolean messengerWritable) {
            this.messengerWritable = Optional.ofNullable(messengerWritable);
            return this;
        }

        @JsonSetter(value="ui_writable", nulls=Nulls.SKIP)
        public Builder uiWritable(Optional<Boolean> uiWritable) {
            this.uiWritable = uiWritable;
            return this;
        }

        public Builder uiWritable(Boolean uiWritable) {
            this.uiWritable = Optional.ofNullable(uiWritable);
            return this;
        }

        @JsonSetter(value="custom", nulls=Nulls.SKIP)
        public Builder custom(Optional<Boolean> custom) {
            this.custom = custom;
            return this;
        }

        public Builder custom(Boolean custom) {
            this.custom = Optional.ofNullable(custom);
            return this;
        }

        @JsonSetter(value="archived", nulls=Nulls.SKIP)
        public Builder archived(Optional<Boolean> archived) {
            this.archived = archived;
            return this;
        }

        public Builder archived(Boolean archived) {
            this.archived = Optional.ofNullable(archived);
            return this;
        }

        @JsonSetter(value="created_at", nulls=Nulls.SKIP)
        public Builder createdAt(Optional<Integer> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder createdAt(Integer createdAt) {
            this.createdAt = Optional.ofNullable(createdAt);
            return this;
        }

        @JsonSetter(value="updated_at", nulls=Nulls.SKIP)
        public Builder updatedAt(Optional<Integer> updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public Builder updatedAt(Integer updatedAt) {
            this.updatedAt = Optional.ofNullable(updatedAt);
            return this;
        }

        @JsonSetter(value="admin_id", nulls=Nulls.SKIP)
        public Builder adminId(Optional<String> adminId) {
            this.adminId = adminId;
            return this;
        }

        public Builder adminId(String adminId) {
            this.adminId = Optional.ofNullable(adminId);
            return this;
        }

        public DataAttribute build() {
            return new DataAttribute(this.type, this.id, this.model, this.name, this.fullName, this.label, this.description, this.dataType, this.options, this.apiWritable, this.messengerWritable, this.uiWritable, this.custom, this.archived, this.createdAt, this.updatedAt, this.adminId, this.additionalProperties);
        }
    }
}

