/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.unstable.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.resources.unstable.types.Reference;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ConversationTeammates {
    private final Optional<String> type;
    private final Optional<List<Reference>> teammates;
    private final Map<String, Object> additionalProperties;

    private ConversationTeammates(Optional<String> type, Optional<List<Reference>> teammates, Map<String, Object> additionalProperties) {
        this.type = type;
        this.teammates = teammates;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="type")
    public Optional<String> getType() {
        return this.type;
    }

    @JsonProperty(value="teammates")
    public Optional<List<Reference>> getTeammates() {
        return this.teammates;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ConversationTeammates && this.equalTo((ConversationTeammates)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ConversationTeammates other) {
        return this.type.equals(other.type) && this.teammates.equals(other.teammates);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.teammates);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> type = Optional.empty();
        private Optional<List<Reference>> teammates = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(ConversationTeammates other) {
            this.type(other.getType());
            this.teammates(other.getTeammates());
            return this;
        }

        @JsonSetter(value="type", nulls=Nulls.SKIP)
        public Builder type(Optional<String> type) {
            this.type = type;
            return this;
        }

        public Builder type(String type) {
            this.type = Optional.ofNullable(type);
            return this;
        }

        @JsonSetter(value="teammates", nulls=Nulls.SKIP)
        public Builder teammates(Optional<List<Reference>> teammates) {
            this.teammates = teammates;
            return this;
        }

        public Builder teammates(List<Reference> teammates) {
            this.teammates = Optional.ofNullable(teammates);
            return this;
        }

        public ConversationTeammates build() {
            return new ConversationTeammates(this.type, this.teammates, this.additionalProperties);
        }
    }
}

