/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.companies.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.annotation.JsonValue;
import com.intercom.api.resources.companies.types.Company;
import com.intercom.api.types.CompanyList;
import java.util.Objects;
import java.util.Optional;

public final class CompaniesRetrieveResponse {
    private final Value value;

    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    private CompaniesRetrieveResponse(Value value) {
        this.value = value;
    }

    public <T> T visit(Visitor<T> visitor) {
        return this.value.visit(visitor);
    }

    public static CompaniesRetrieveResponse company(Company value) {
        return new CompaniesRetrieveResponse(new CompanyValue(value));
    }

    public static CompaniesRetrieveResponse list(CompanyList value) {
        return new CompaniesRetrieveResponse(new ListValue(value));
    }

    public boolean isCompany() {
        return this.value instanceof CompanyValue;
    }

    public boolean isList() {
        return this.value instanceof ListValue;
    }

    public boolean _isUnknown() {
        return this.value instanceof _UnknownValue;
    }

    public Optional<Company> getCompany() {
        if (this.isCompany()) {
            return Optional.of(((CompanyValue)this.value).value);
        }
        return Optional.empty();
    }

    public Optional<CompanyList> getList() {
        if (this.isList()) {
            return Optional.of(((ListValue)this.value).value);
        }
        return Optional.empty();
    }

    public Optional<Object> _getUnknown() {
        if (this._isUnknown()) {
            return Optional.of(((_UnknownValue)this.value).value);
        }
        return Optional.empty();
    }

    @JsonValue
    private Value getValue() {
        return this.value;
    }

    @JsonIgnoreProperties(value={"type"})
    private static final class _UnknownValue
    implements Value {
        private String type;
        @JsonValue
        private Object value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private _UnknownValue(@JsonProperty(value="value") Object value) {
        }

        @Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor._visitUnknown(this.value);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof _UnknownValue && this.equalTo((_UnknownValue)other);
        }

        private boolean equalTo(_UnknownValue other) {
            return this.type.equals(other.type) && this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hash(this.type, this.value);
        }

        public String toString() {
            return "CompaniesRetrieveResponse{type: " + this.type + ", value: " + this.value + "}";
        }
    }

    @JsonTypeName(value="list")
    @JsonIgnoreProperties(value={"type"})
    private static final class ListValue
    implements Value {
        @JsonUnwrapped
        private CompanyList value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private ListValue() {
        }

        private ListValue(CompanyList value) {
            this.value = value;
        }

        @Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor.visitList(this.value);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof ListValue && this.equalTo((ListValue)other);
        }

        private boolean equalTo(ListValue other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return "CompaniesRetrieveResponse{value: " + this.value + "}";
        }
    }

    @JsonTypeName(value="company")
    @JsonIgnoreProperties(value={"type"})
    private static final class CompanyValue
    implements Value {
        @JsonUnwrapped
        private Company value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private CompanyValue() {
        }

        private CompanyValue(Company value) {
            this.value = value;
        }

        @Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor.visitCompany(this.value);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof CompanyValue && this.equalTo((CompanyValue)other);
        }

        private boolean equalTo(CompanyValue other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return "CompaniesRetrieveResponse{value: " + this.value + "}";
        }
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type", visible=true, defaultImpl=_UnknownValue.class)
    @JsonSubTypes(value={@JsonSubTypes.Type(value=CompanyValue.class), @JsonSubTypes.Type(value=ListValue.class)})
    @JsonIgnoreProperties(ignoreUnknown=true)
    private static interface Value {
        public <T> T visit(Visitor<T> var1);
    }

    public static interface Visitor<T> {
        public T visitCompany(Company var1);

        public T visitList(CompanyList var1);

        public T _visitUnknown(Object var1);
    }
}

