/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.news.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.resources.news.types.NewsfeedAssignment;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class NewsItem {
    private final String id;
    private final String workspaceId;
    private final String title;
    private final Optional<String> body;
    private final Optional<Integer> senderId;
    private final State state;
    private final Optional<List<NewsfeedAssignment>> newsfeedAssignments;
    private final Optional<List<Optional<String>>> labels;
    private final Optional<String> coverImageUrl;
    private final Optional<List<Optional<String>>> reactions;
    private final Optional<Boolean> deliverSilently;
    private final int createdAt;
    private final int updatedAt;
    private final Map<String, Object> additionalProperties;

    private NewsItem(String id, String workspaceId, String title, Optional<String> body, Optional<Integer> senderId, State state, Optional<List<NewsfeedAssignment>> newsfeedAssignments, Optional<List<Optional<String>>> labels, Optional<String> coverImageUrl, Optional<List<Optional<String>>> reactions, Optional<Boolean> deliverSilently, int createdAt, int updatedAt, Map<String, Object> additionalProperties) {
        this.id = id;
        this.workspaceId = workspaceId;
        this.title = title;
        this.body = body;
        this.senderId = senderId;
        this.state = state;
        this.newsfeedAssignments = newsfeedAssignments;
        this.labels = labels;
        this.coverImageUrl = coverImageUrl;
        this.reactions = reactions;
        this.deliverSilently = deliverSilently;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="type")
    public String getType() {
        return "news-item";
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="workspace_id")
    public String getWorkspaceId() {
        return this.workspaceId;
    }

    @JsonProperty(value="title")
    public String getTitle() {
        return this.title;
    }

    @JsonProperty(value="body")
    public Optional<String> getBody() {
        return this.body;
    }

    @JsonProperty(value="sender_id")
    public Optional<Integer> getSenderId() {
        return this.senderId;
    }

    @JsonProperty(value="state")
    public State getState() {
        return this.state;
    }

    @JsonProperty(value="newsfeed_assignments")
    public Optional<List<NewsfeedAssignment>> getNewsfeedAssignments() {
        return this.newsfeedAssignments;
    }

    @JsonProperty(value="labels")
    public Optional<List<Optional<String>>> getLabels() {
        return this.labels;
    }

    @JsonProperty(value="cover_image_url")
    public Optional<String> getCoverImageUrl() {
        return this.coverImageUrl;
    }

    @JsonProperty(value="reactions")
    public Optional<List<Optional<String>>> getReactions() {
        return this.reactions;
    }

    @JsonProperty(value="deliver_silently")
    public Optional<Boolean> getDeliverSilently() {
        return this.deliverSilently;
    }

    @JsonProperty(value="created_at")
    public int getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="updated_at")
    public int getUpdatedAt() {
        return this.updatedAt;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof NewsItem && this.equalTo((NewsItem)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(NewsItem other) {
        return this.id.equals(other.id) && this.workspaceId.equals(other.workspaceId) && this.title.equals(other.title) && this.body.equals(other.body) && this.senderId.equals(other.senderId) && this.state.equals(other.state) && this.newsfeedAssignments.equals(other.newsfeedAssignments) && this.labels.equals(other.labels) && this.coverImageUrl.equals(other.coverImageUrl) && this.reactions.equals(other.reactions) && this.deliverSilently.equals(other.deliverSilently) && this.createdAt == other.createdAt && this.updatedAt == other.updatedAt;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.workspaceId, this.title, this.body, this.senderId, this.state, this.newsfeedAssignments, this.labels, this.coverImageUrl, this.reactions, this.deliverSilently, this.createdAt, this.updatedAt);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    public static final class State {
        public static final State LIVE = new State(Value.LIVE, "live");
        public static final State DRAFT = new State(Value.DRAFT, "draft");
        private final Value value;
        private final String string;

        State(Value value, String string) {
            this.value = value;
            this.string = string;
        }

        public Value getEnumValue() {
            return this.value;
        }

        @JsonValue
        public String toString() {
            return this.string;
        }

        public boolean equals(Object other) {
            return this == other || other instanceof State && this.string.equals(((State)other).string);
        }

        public int hashCode() {
            return this.string.hashCode();
        }

        public <T> T visit(Visitor<T> visitor) {
            switch (this.value) {
                case LIVE: {
                    return visitor.visitLive();
                }
                case DRAFT: {
                    return visitor.visitDraft();
                }
            }
            return visitor.visitUnknown(this.string);
        }

        @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
        public static State valueOf(String value) {
            switch (value) {
                case "live": {
                    return LIVE;
                }
                case "draft": {
                    return DRAFT;
                }
            }
            return new State(Value.UNKNOWN, value);
        }

        public static interface Visitor<T> {
            public T visitDraft();

            public T visitLive();

            public T visitUnknown(String var1);
        }

        public static enum Value {
            DRAFT,
            LIVE,
            UNKNOWN;

        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements IdStage,
    WorkspaceIdStage,
    TitleStage,
    StateStage,
    CreatedAtStage,
    UpdatedAtStage,
    _FinalStage {
        private String id;
        private String workspaceId;
        private String title;
        private State state;
        private int createdAt;
        private int updatedAt;
        private Optional<Boolean> deliverSilently = Optional.empty();
        private Optional<List<Optional<String>>> reactions = Optional.empty();
        private Optional<String> coverImageUrl = Optional.empty();
        private Optional<List<Optional<String>>> labels = Optional.empty();
        private Optional<List<NewsfeedAssignment>> newsfeedAssignments = Optional.empty();
        private Optional<Integer> senderId = Optional.empty();
        private Optional<String> body = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(NewsItem other) {
            this.id(other.getId());
            this.workspaceId(other.getWorkspaceId());
            this.title(other.getTitle());
            this.body(other.getBody());
            this.senderId(other.getSenderId());
            this.state(other.getState());
            this.newsfeedAssignments(other.getNewsfeedAssignments());
            this.labels(other.getLabels());
            this.coverImageUrl(other.getCoverImageUrl());
            this.reactions(other.getReactions());
            this.deliverSilently(other.getDeliverSilently());
            this.createdAt(other.getCreatedAt());
            this.updatedAt(other.getUpdatedAt());
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public WorkspaceIdStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="workspace_id")
        public TitleStage workspaceId(@NotNull String workspaceId) {
            this.workspaceId = Objects.requireNonNull(workspaceId, "workspaceId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="title")
        public StateStage title(@NotNull String title) {
            this.title = Objects.requireNonNull(title, "title must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="state")
        public CreatedAtStage state(@NotNull State state) {
            this.state = Objects.requireNonNull(state, "state must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="created_at")
        public UpdatedAtStage createdAt(int createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        @Override
        @JsonSetter(value="updated_at")
        public _FinalStage updatedAt(int updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Override
        public _FinalStage deliverSilently(Boolean deliverSilently) {
            this.deliverSilently = Optional.ofNullable(deliverSilently);
            return this;
        }

        @Override
        @JsonSetter(value="deliver_silently", nulls=Nulls.SKIP)
        public _FinalStage deliverSilently(Optional<Boolean> deliverSilently) {
            this.deliverSilently = deliverSilently;
            return this;
        }

        @Override
        public _FinalStage reactions(List<Optional<String>> reactions) {
            this.reactions = Optional.ofNullable(reactions);
            return this;
        }

        @Override
        @JsonSetter(value="reactions", nulls=Nulls.SKIP)
        public _FinalStage reactions(Optional<List<Optional<String>>> reactions) {
            this.reactions = reactions;
            return this;
        }

        @Override
        public _FinalStage coverImageUrl(String coverImageUrl) {
            this.coverImageUrl = Optional.ofNullable(coverImageUrl);
            return this;
        }

        @Override
        @JsonSetter(value="cover_image_url", nulls=Nulls.SKIP)
        public _FinalStage coverImageUrl(Optional<String> coverImageUrl) {
            this.coverImageUrl = coverImageUrl;
            return this;
        }

        @Override
        public _FinalStage labels(List<Optional<String>> labels) {
            this.labels = Optional.ofNullable(labels);
            return this;
        }

        @Override
        @JsonSetter(value="labels", nulls=Nulls.SKIP)
        public _FinalStage labels(Optional<List<Optional<String>>> labels) {
            this.labels = labels;
            return this;
        }

        @Override
        public _FinalStage newsfeedAssignments(List<NewsfeedAssignment> newsfeedAssignments) {
            this.newsfeedAssignments = Optional.ofNullable(newsfeedAssignments);
            return this;
        }

        @Override
        @JsonSetter(value="newsfeed_assignments", nulls=Nulls.SKIP)
        public _FinalStage newsfeedAssignments(Optional<List<NewsfeedAssignment>> newsfeedAssignments) {
            this.newsfeedAssignments = newsfeedAssignments;
            return this;
        }

        @Override
        public _FinalStage senderId(Integer senderId) {
            this.senderId = Optional.ofNullable(senderId);
            return this;
        }

        @Override
        @JsonSetter(value="sender_id", nulls=Nulls.SKIP)
        public _FinalStage senderId(Optional<Integer> senderId) {
            this.senderId = senderId;
            return this;
        }

        @Override
        public _FinalStage body(String body) {
            this.body = Optional.ofNullable(body);
            return this;
        }

        @Override
        @JsonSetter(value="body", nulls=Nulls.SKIP)
        public _FinalStage body(Optional<String> body) {
            this.body = body;
            return this;
        }

        @Override
        public NewsItem build() {
            return new NewsItem(this.id, this.workspaceId, this.title, this.body, this.senderId, this.state, this.newsfeedAssignments, this.labels, this.coverImageUrl, this.reactions, this.deliverSilently, this.createdAt, this.updatedAt, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public NewsItem build();

        public _FinalStage body(Optional<String> var1);

        public _FinalStage body(String var1);

        public _FinalStage senderId(Optional<Integer> var1);

        public _FinalStage senderId(Integer var1);

        public _FinalStage newsfeedAssignments(Optional<List<NewsfeedAssignment>> var1);

        public _FinalStage newsfeedAssignments(List<NewsfeedAssignment> var1);

        public _FinalStage labels(Optional<List<Optional<String>>> var1);

        public _FinalStage labels(List<Optional<String>> var1);

        public _FinalStage coverImageUrl(Optional<String> var1);

        public _FinalStage coverImageUrl(String var1);

        public _FinalStage reactions(Optional<List<Optional<String>>> var1);

        public _FinalStage reactions(List<Optional<String>> var1);

        public _FinalStage deliverSilently(Optional<Boolean> var1);

        public _FinalStage deliverSilently(Boolean var1);
    }

    public static interface UpdatedAtStage {
        public _FinalStage updatedAt(int var1);
    }

    public static interface CreatedAtStage {
        public UpdatedAtStage createdAt(int var1);
    }

    public static interface StateStage {
        public CreatedAtStage state(@NotNull State var1);
    }

    public static interface TitleStage {
        public StateStage title(@NotNull String var1);
    }

    public static interface WorkspaceIdStage {
        public TitleStage workspaceId(@NotNull String var1);
    }

    public static interface IdStage {
        public WorkspaceIdStage id(@NotNull String var1);

        public Builder from(NewsItem var1);
    }
}

