/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.segments.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class Segment {
    private final String id;
    private final String name;
    private final int createdAt;
    private final int updatedAt;
    private final PersonType personType;
    private final Optional<Integer> count;
    private final Map<String, Object> additionalProperties;

    private Segment(String id, String name, int createdAt, int updatedAt, PersonType personType, Optional<Integer> count, Map<String, Object> additionalProperties) {
        this.id = id;
        this.name = name;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.personType = personType;
        this.count = count;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="type")
    public String getType() {
        return "segment";
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="created_at")
    public int getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="updated_at")
    public int getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonProperty(value="person_type")
    public PersonType getPersonType() {
        return this.personType;
    }

    @JsonProperty(value="count")
    public Optional<Integer> getCount() {
        return this.count;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof Segment && this.equalTo((Segment)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(Segment other) {
        return this.id.equals(other.id) && this.name.equals(other.name) && this.createdAt == other.createdAt && this.updatedAt == other.updatedAt && this.personType.equals(other.personType) && this.count.equals(other.count);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.createdAt, this.updatedAt, this.personType, this.count);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    public static final class PersonType {
        public static final PersonType USER = new PersonType(Value.USER, "user");
        public static final PersonType CONTACT = new PersonType(Value.CONTACT, "contact");
        private final Value value;
        private final String string;

        PersonType(Value value, String string) {
            this.value = value;
            this.string = string;
        }

        public Value getEnumValue() {
            return this.value;
        }

        @JsonValue
        public String toString() {
            return this.string;
        }

        public boolean equals(Object other) {
            return this == other || other instanceof PersonType && this.string.equals(((PersonType)other).string);
        }

        public int hashCode() {
            return this.string.hashCode();
        }

        public <T> T visit(Visitor<T> visitor) {
            switch (this.value) {
                case USER: {
                    return visitor.visitUser();
                }
                case CONTACT: {
                    return visitor.visitContact();
                }
            }
            return visitor.visitUnknown(this.string);
        }

        @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
        public static PersonType valueOf(String value) {
            switch (value) {
                case "user": {
                    return USER;
                }
                case "contact": {
                    return CONTACT;
                }
            }
            return new PersonType(Value.UNKNOWN, value);
        }

        public static interface Visitor<T> {
            public T visitContact();

            public T visitUser();

            public T visitUnknown(String var1);
        }

        public static enum Value {
            CONTACT,
            USER,
            UNKNOWN;

        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements IdStage,
    NameStage,
    CreatedAtStage,
    UpdatedAtStage,
    PersonTypeStage,
    _FinalStage {
        private String id;
        private String name;
        private int createdAt;
        private int updatedAt;
        private PersonType personType;
        private Optional<Integer> count = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(Segment other) {
            this.id(other.getId());
            this.name(other.getName());
            this.createdAt(other.getCreatedAt());
            this.updatedAt(other.getUpdatedAt());
            this.personType(other.getPersonType());
            this.count(other.getCount());
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public NameStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="name")
        public CreatedAtStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="created_at")
        public UpdatedAtStage createdAt(int createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        @Override
        @JsonSetter(value="updated_at")
        public PersonTypeStage updatedAt(int updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Override
        @JsonSetter(value="person_type")
        public _FinalStage personType(@NotNull PersonType personType) {
            this.personType = Objects.requireNonNull(personType, "personType must not be null");
            return this;
        }

        @Override
        public _FinalStage count(Integer count) {
            this.count = Optional.ofNullable(count);
            return this;
        }

        @Override
        @JsonSetter(value="count", nulls=Nulls.SKIP)
        public _FinalStage count(Optional<Integer> count) {
            this.count = count;
            return this;
        }

        @Override
        public Segment build() {
            return new Segment(this.id, this.name, this.createdAt, this.updatedAt, this.personType, this.count, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public Segment build();

        public _FinalStage count(Optional<Integer> var1);

        public _FinalStage count(Integer var1);
    }

    public static interface PersonTypeStage {
        public _FinalStage personType(@NotNull PersonType var1);
    }

    public static interface UpdatedAtStage {
        public PersonTypeStage updatedAt(int var1);
    }

    public static interface CreatedAtStage {
        public UpdatedAtStage createdAt(int var1);
    }

    public static interface NameStage {
        public CreatedAtStage name(@NotNull String var1);
    }

    public static interface IdStage {
        public NameStage id(@NotNull String var1);

        public Builder from(Segment var1);
    }
}

