/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ConversationAttributeUpdatedByWorkflow {
    private final Optional<Workflow> workflow;
    private final Optional<Attribute> attribute;
    private final Optional<Value> value;
    private final Map<String, Object> additionalProperties;

    private ConversationAttributeUpdatedByWorkflow(Optional<Workflow> workflow, Optional<Attribute> attribute, Optional<Value> value, Map<String, Object> additionalProperties) {
        this.workflow = workflow;
        this.attribute = attribute;
        this.value = value;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="workflow")
    public Optional<Workflow> getWorkflow() {
        return this.workflow;
    }

    @JsonProperty(value="attribute")
    public Optional<Attribute> getAttribute() {
        return this.attribute;
    }

    @JsonProperty(value="value")
    public Optional<Value> getValue() {
        return this.value;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ConversationAttributeUpdatedByWorkflow && this.equalTo((ConversationAttributeUpdatedByWorkflow)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ConversationAttributeUpdatedByWorkflow other) {
        return this.workflow.equals(other.workflow) && this.attribute.equals(other.attribute) && this.value.equals(other.value);
    }

    public int hashCode() {
        return Objects.hash(this.workflow, this.attribute, this.value);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonDeserialize(builder=Builder.class)
    public static final class Value {
        private final Optional<String> name;
        private final Map<String, Object> additionalProperties;

        private Value(Optional<String> name, Map<String, Object> additionalProperties) {
            this.name = name;
            this.additionalProperties = additionalProperties;
        }

        @JsonProperty(value="name")
        public Optional<String> getName() {
            return this.name;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof Value && this.equalTo((Value)other);
        }

        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        private boolean equalTo(Value other) {
            return this.name.equals(other.name);
        }

        public int hashCode() {
            return Objects.hash(this.name);
        }

        public String toString() {
            return ObjectMappers.stringify(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        public static final class Builder {
            private Optional<String> name = Optional.empty();
            @JsonAnySetter
            private Map<String, Object> additionalProperties = new HashMap<String, Object>();

            private Builder() {
            }

            public Builder from(Value other) {
                this.name(other.getName());
                return this;
            }

            @JsonSetter(value="name", nulls=Nulls.SKIP)
            public Builder name(Optional<String> name) {
                this.name = name;
                return this;
            }

            public Builder name(String name) {
                this.name = Optional.ofNullable(name);
                return this;
            }

            public Value build() {
                return new Value(this.name, this.additionalProperties);
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonDeserialize(builder=Builder.class)
    public static final class Attribute {
        private final Optional<String> name;
        private final Map<String, Object> additionalProperties;

        private Attribute(Optional<String> name, Map<String, Object> additionalProperties) {
            this.name = name;
            this.additionalProperties = additionalProperties;
        }

        @JsonProperty(value="name")
        public Optional<String> getName() {
            return this.name;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof Attribute && this.equalTo((Attribute)other);
        }

        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        private boolean equalTo(Attribute other) {
            return this.name.equals(other.name);
        }

        public int hashCode() {
            return Objects.hash(this.name);
        }

        public String toString() {
            return ObjectMappers.stringify(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        public static final class Builder {
            private Optional<String> name = Optional.empty();
            @JsonAnySetter
            private Map<String, Object> additionalProperties = new HashMap<String, Object>();

            private Builder() {
            }

            public Builder from(Attribute other) {
                this.name(other.getName());
                return this;
            }

            @JsonSetter(value="name", nulls=Nulls.SKIP)
            public Builder name(Optional<String> name) {
                this.name = name;
                return this;
            }

            public Builder name(String name) {
                this.name = Optional.ofNullable(name);
                return this;
            }

            public Attribute build() {
                return new Attribute(this.name, this.additionalProperties);
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonDeserialize(builder=Builder.class)
    public static final class Workflow {
        private final Optional<String> name;
        private final Map<String, Object> additionalProperties;

        private Workflow(Optional<String> name, Map<String, Object> additionalProperties) {
            this.name = name;
            this.additionalProperties = additionalProperties;
        }

        @JsonProperty(value="name")
        public Optional<String> getName() {
            return this.name;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof Workflow && this.equalTo((Workflow)other);
        }

        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        private boolean equalTo(Workflow other) {
            return this.name.equals(other.name);
        }

        public int hashCode() {
            return Objects.hash(this.name);
        }

        public String toString() {
            return ObjectMappers.stringify(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        public static final class Builder {
            private Optional<String> name = Optional.empty();
            @JsonAnySetter
            private Map<String, Object> additionalProperties = new HashMap<String, Object>();

            private Builder() {
            }

            public Builder from(Workflow other) {
                this.name(other.getName());
                return this;
            }

            @JsonSetter(value="name", nulls=Nulls.SKIP)
            public Builder name(Optional<String> name) {
                this.name = name;
                return this;
            }

            public Builder name(String name) {
                this.name = Optional.ofNullable(name);
                return this;
            }

            public Workflow build() {
                return new Workflow(this.name, this.additionalProperties);
            }
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<Workflow> workflow = Optional.empty();
        private Optional<Attribute> attribute = Optional.empty();
        private Optional<Value> value = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(ConversationAttributeUpdatedByWorkflow other) {
            this.workflow(other.getWorkflow());
            this.attribute(other.getAttribute());
            this.value(other.getValue());
            return this;
        }

        @JsonSetter(value="workflow", nulls=Nulls.SKIP)
        public Builder workflow(Optional<Workflow> workflow) {
            this.workflow = workflow;
            return this;
        }

        public Builder workflow(Workflow workflow) {
            this.workflow = Optional.ofNullable(workflow);
            return this;
        }

        @JsonSetter(value="attribute", nulls=Nulls.SKIP)
        public Builder attribute(Optional<Attribute> attribute) {
            this.attribute = attribute;
            return this;
        }

        public Builder attribute(Attribute attribute) {
            this.attribute = Optional.ofNullable(attribute);
            return this;
        }

        @JsonSetter(value="value", nulls=Nulls.SKIP)
        public Builder value(Optional<Value> value) {
            this.value = value;
            return this;
        }

        public Builder value(Value value) {
            this.value = Optional.ofNullable(value);
            return this;
        }

        public ConversationAttributeUpdatedByWorkflow build() {
            return new ConversationAttributeUpdatedByWorkflow(this.workflow, this.attribute, this.value, this.additionalProperties);
        }
    }
}

