/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.types.ContactReference;
import com.intercom.api.types.Reference;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ConversationRating {
    private final int rating;
    private final Optional<String> remark;
    private final int createdAt;
    private final Optional<Integer> updatedAt;
    private final Optional<ContactReference> contact;
    private final Optional<Reference> teammate;
    private final Map<String, Object> additionalProperties;

    private ConversationRating(int rating, Optional<String> remark, int createdAt, Optional<Integer> updatedAt, Optional<ContactReference> contact, Optional<Reference> teammate, Map<String, Object> additionalProperties) {
        this.rating = rating;
        this.remark = remark;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.contact = contact;
        this.teammate = teammate;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="rating")
    public int getRating() {
        return this.rating;
    }

    @JsonProperty(value="remark")
    public Optional<String> getRemark() {
        return this.remark;
    }

    @JsonProperty(value="created_at")
    public int getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="updated_at")
    public Optional<Integer> getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonProperty(value="contact")
    public Optional<ContactReference> getContact() {
        return this.contact;
    }

    @JsonProperty(value="teammate")
    public Optional<Reference> getTeammate() {
        return this.teammate;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ConversationRating && this.equalTo((ConversationRating)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ConversationRating other) {
        return this.rating == other.rating && this.remark.equals(other.remark) && this.createdAt == other.createdAt && this.updatedAt.equals(other.updatedAt) && this.contact.equals(other.contact) && this.teammate.equals(other.teammate);
    }

    public int hashCode() {
        return Objects.hash(this.rating, this.remark, this.createdAt, this.updatedAt, this.contact, this.teammate);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static RatingStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements RatingStage,
    CreatedAtStage,
    _FinalStage {
        private int rating;
        private int createdAt;
        private Optional<Reference> teammate = Optional.empty();
        private Optional<ContactReference> contact = Optional.empty();
        private Optional<Integer> updatedAt = Optional.empty();
        private Optional<String> remark = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(ConversationRating other) {
            this.rating(other.getRating());
            this.remark(other.getRemark());
            this.createdAt(other.getCreatedAt());
            this.updatedAt(other.getUpdatedAt());
            this.contact(other.getContact());
            this.teammate(other.getTeammate());
            return this;
        }

        @Override
        @JsonSetter(value="rating")
        public CreatedAtStage rating(int rating) {
            this.rating = rating;
            return this;
        }

        @Override
        @JsonSetter(value="created_at")
        public _FinalStage createdAt(int createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        @Override
        public _FinalStage teammate(Reference teammate) {
            this.teammate = Optional.ofNullable(teammate);
            return this;
        }

        @Override
        @JsonSetter(value="teammate", nulls=Nulls.SKIP)
        public _FinalStage teammate(Optional<Reference> teammate) {
            this.teammate = teammate;
            return this;
        }

        @Override
        public _FinalStage contact(ContactReference contact) {
            this.contact = Optional.ofNullable(contact);
            return this;
        }

        @Override
        @JsonSetter(value="contact", nulls=Nulls.SKIP)
        public _FinalStage contact(Optional<ContactReference> contact) {
            this.contact = contact;
            return this;
        }

        @Override
        public _FinalStage updatedAt(Integer updatedAt) {
            this.updatedAt = Optional.ofNullable(updatedAt);
            return this;
        }

        @Override
        @JsonSetter(value="updated_at", nulls=Nulls.SKIP)
        public _FinalStage updatedAt(Optional<Integer> updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Override
        public _FinalStage remark(String remark) {
            this.remark = Optional.ofNullable(remark);
            return this;
        }

        @Override
        @JsonSetter(value="remark", nulls=Nulls.SKIP)
        public _FinalStage remark(Optional<String> remark) {
            this.remark = remark;
            return this;
        }

        @Override
        public ConversationRating build() {
            return new ConversationRating(this.rating, this.remark, this.createdAt, this.updatedAt, this.contact, this.teammate, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public ConversationRating build();

        public _FinalStage remark(Optional<String> var1);

        public _FinalStage remark(String var1);

        public _FinalStage updatedAt(Optional<Integer> var1);

        public _FinalStage updatedAt(Integer var1);

        public _FinalStage contact(Optional<ContactReference> var1);

        public _FinalStage contact(ContactReference var1);

        public _FinalStage teammate(Optional<Reference> var1);

        public _FinalStage teammate(Reference var1);
    }

    public static interface CreatedAtStage {
        public _FinalStage createdAt(int var1);
    }

    public static interface RatingStage {
        public CreatedAtStage rating(int var1);

        public Builder from(ConversationRating var1);
    }
}

