/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class PartAttachment {
    private final String type;
    private final String name;
    private final String url;
    private final Optional<String> contentType;
    private final Optional<Integer> filesize;
    private final Optional<Integer> width;
    private final Optional<Integer> height;
    private final Map<String, Object> additionalProperties;

    private PartAttachment(String type, String name, String url, Optional<String> contentType, Optional<Integer> filesize, Optional<Integer> width, Optional<Integer> height, Map<String, Object> additionalProperties) {
        this.type = type;
        this.name = name;
        this.url = url;
        this.contentType = contentType;
        this.filesize = filesize;
        this.width = width;
        this.height = height;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="type")
    public String getType() {
        return this.type;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="url")
    public String getUrl() {
        return this.url;
    }

    @JsonProperty(value="content_type")
    public Optional<String> getContentType() {
        return this.contentType;
    }

    @JsonProperty(value="filesize")
    public Optional<Integer> getFilesize() {
        return this.filesize;
    }

    @JsonProperty(value="width")
    public Optional<Integer> getWidth() {
        return this.width;
    }

    @JsonProperty(value="height")
    public Optional<Integer> getHeight() {
        return this.height;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof PartAttachment && this.equalTo((PartAttachment)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(PartAttachment other) {
        return this.type.equals(other.type) && this.name.equals(other.name) && this.url.equals(other.url) && this.contentType.equals(other.contentType) && this.filesize.equals(other.filesize) && this.width.equals(other.width) && this.height.equals(other.height);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.name, this.url, this.contentType, this.filesize, this.width, this.height);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TypeStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements TypeStage,
    NameStage,
    UrlStage,
    _FinalStage {
        private String type;
        private String name;
        private String url;
        private Optional<Integer> height = Optional.empty();
        private Optional<Integer> width = Optional.empty();
        private Optional<Integer> filesize = Optional.empty();
        private Optional<String> contentType = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(PartAttachment other) {
            this.type(other.getType());
            this.name(other.getName());
            this.url(other.getUrl());
            this.contentType(other.getContentType());
            this.filesize(other.getFilesize());
            this.width(other.getWidth());
            this.height(other.getHeight());
            return this;
        }

        @Override
        @JsonSetter(value="type")
        public NameStage type(@NotNull String type) {
            this.type = Objects.requireNonNull(type, "type must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="name")
        public UrlStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="url")
        public _FinalStage url(@NotNull String url) {
            this.url = Objects.requireNonNull(url, "url must not be null");
            return this;
        }

        @Override
        public _FinalStage height(Integer height) {
            this.height = Optional.ofNullable(height);
            return this;
        }

        @Override
        @JsonSetter(value="height", nulls=Nulls.SKIP)
        public _FinalStage height(Optional<Integer> height) {
            this.height = height;
            return this;
        }

        @Override
        public _FinalStage width(Integer width) {
            this.width = Optional.ofNullable(width);
            return this;
        }

        @Override
        @JsonSetter(value="width", nulls=Nulls.SKIP)
        public _FinalStage width(Optional<Integer> width) {
            this.width = width;
            return this;
        }

        @Override
        public _FinalStage filesize(Integer filesize) {
            this.filesize = Optional.ofNullable(filesize);
            return this;
        }

        @Override
        @JsonSetter(value="filesize", nulls=Nulls.SKIP)
        public _FinalStage filesize(Optional<Integer> filesize) {
            this.filesize = filesize;
            return this;
        }

        @Override
        public _FinalStage contentType(String contentType) {
            this.contentType = Optional.ofNullable(contentType);
            return this;
        }

        @Override
        @JsonSetter(value="content_type", nulls=Nulls.SKIP)
        public _FinalStage contentType(Optional<String> contentType) {
            this.contentType = contentType;
            return this;
        }

        @Override
        public PartAttachment build() {
            return new PartAttachment(this.type, this.name, this.url, this.contentType, this.filesize, this.width, this.height, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public PartAttachment build();

        public _FinalStage contentType(Optional<String> var1);

        public _FinalStage contentType(String var1);

        public _FinalStage filesize(Optional<Integer> var1);

        public _FinalStage filesize(Integer var1);

        public _FinalStage width(Optional<Integer> var1);

        public _FinalStage width(Integer var1);

        public _FinalStage height(Optional<Integer> var1);

        public _FinalStage height(Integer var1);
    }

    public static interface UrlStage {
        public _FinalStage url(@NotNull String var1);
    }

    public static interface NameStage {
        public UrlStage name(@NotNull String var1);
    }

    public static interface TypeStage {
        public NameStage type(@NotNull String var1);

        public Builder from(PartAttachment var1);
    }
}

