/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.authcodeflowproxy.api.controller;

import io.mosip.kernel.authcodeflowproxy.api.constants.Errors;
import io.mosip.kernel.authcodeflowproxy.api.dto.AccessTokenResponseDTO;
import io.mosip.kernel.authcodeflowproxy.api.dto.MosipUserDto;
import io.mosip.kernel.authcodeflowproxy.api.exception.ClientException;
import io.mosip.kernel.authcodeflowproxy.api.service.LoginService;
import io.mosip.kernel.core.authmanager.model.AuthResponseDto;
import io.mosip.kernel.core.http.ResponseFilter;
import io.mosip.kernel.core.http.ResponseWrapper;
import java.io.IOException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.CookieValue;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class LoginController {
    @Value(value="${auth.token.header:Authorization}")
    private String authTokenHeader;
    @Autowired
    private LoginService loginService;

    @GetMapping(value={"/login/{redirectURI}"})
    public void login(@CookieValue(value="state") String state, @PathVariable(value="redirectURI") String redirectURI, HttpServletResponse res) throws IOException {
        String uri = this.loginService.login(redirectURI, state);
        res.setStatus(302);
        res.sendRedirect(uri);
    }

    @GetMapping(value={"/login-redirect/{redirectURI}"})
    public void loginRedirect(@PathVariable(value="redirectURI") String redirectURI, @RequestParam(value="state") String state, @RequestParam(value="session_state") String sessionState, @RequestParam(value="code") String code, @CookieValue(value="state") String stateCookie, HttpServletResponse res) throws IOException {
        AccessTokenResponseDTO jwtResponseDTO = this.loginService.loginRedirect(state, sessionState, code, stateCookie, redirectURI);
        Cookie cookie = this.loginService.createCookie(jwtResponseDTO.getAccessToken());
        res.addCookie(cookie);
        res.setStatus(302);
        String uri = new String(Base64.decodeBase64((byte[])redirectURI.getBytes()));
        res.sendRedirect(uri);
    }

    @ResponseFilter
    @GetMapping(value={"/authorize/admin/validateToken"})
    public ResponseWrapper<MosipUserDto> validateAdminToken(HttpServletRequest request, HttpServletResponse res) {
        String authToken = null;
        Cookie[] cookies = request.getCookies();
        if (cookies == null) {
            throw new ClientException(Errors.COOKIE_NOTPRESENT_ERROR.getErrorCode(), Errors.COOKIE_NOTPRESENT_ERROR.getErrorMessage());
        }
        MosipUserDto mosipUserDto = null;
        for (Cookie cookie : cookies) {
            if (!cookie.getName().contains(this.authTokenHeader)) continue;
            authToken = cookie.getValue();
        }
        if (authToken == null) {
            throw new ClientException(Errors.TOKEN_NOTPRESENT_ERROR.getErrorCode(), Errors.TOKEN_NOTPRESENT_ERROR.getErrorMessage());
        }
        mosipUserDto = this.loginService.valdiateToken(authToken);
        Cookie cookie = this.loginService.createCookie(authToken);
        res.addCookie(cookie);
        ResponseWrapper responseWrapper = new ResponseWrapper();
        responseWrapper.setResponse((Object)mosipUserDto);
        return responseWrapper;
    }

    @ResponseFilter
    @DeleteMapping(value={"/logout/user"})
    public ResponseWrapper<AuthResponseDto> logoutUser(@CookieValue(value="Authorization", required=false) String token, HttpServletResponse res) {
        AuthResponseDto authResponseDto = this.loginService.logoutUser(token);
        ResponseWrapper responseWrapper = new ResponseWrapper();
        responseWrapper.setResponse((Object)authResponseDto);
        return responseWrapper;
    }
}

