/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.authcodeflowproxy.api.service.impl;

import com.auth0.jwt.JWT;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.mosip.kernel.authcodeflowproxy.api.constants.Errors;
import io.mosip.kernel.authcodeflowproxy.api.dto.AccessTokenResponse;
import io.mosip.kernel.authcodeflowproxy.api.dto.AccessTokenResponseDTO;
import io.mosip.kernel.authcodeflowproxy.api.dto.IAMErrorResponseDto;
import io.mosip.kernel.authcodeflowproxy.api.dto.MosipUserDto;
import io.mosip.kernel.authcodeflowproxy.api.exception.AuthRestException;
import io.mosip.kernel.authcodeflowproxy.api.exception.ClientException;
import io.mosip.kernel.authcodeflowproxy.api.exception.ServiceException;
import io.mosip.kernel.authcodeflowproxy.api.service.LoginService;
import io.mosip.kernel.core.authmanager.model.AuthResponseDto;
import io.mosip.kernel.core.exception.ExceptionUtils;
import io.mosip.kernel.core.http.ResponseWrapper;
import io.mosip.kernel.core.util.EmptyCheckUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.Cookie;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.HttpServerErrorException;
import org.springframework.web.client.HttpStatusCodeException;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

@Service
public class LoginServiceImpl
implements LoginService {
    @Value(value="${mosip.kernel.auth-code-url-splitter:#URISPLITTER#}")
    private String urlSplitter;
    @Value(value="${mosip.security.secure-cookie:false}")
    private boolean isSecureCookie;
    @Value(value="${auth.token.header:Authorization}")
    private String authTokenHeader;
    @Value(value="${auth.jwt.expiry:1800000}")
    private int authTokenExpiry;
    @Value(value="${mosip.iam.module.login_flow.name:authorization_code}")
    private String loginFlowName;
    @Value(value="${mosip.iam.module.clientid}")
    private String clientID;
    @Value(value="${mosip.iam.module.clientsecret}")
    private String clientSecret;
    @Value(value="${mosip.iam.module.redirecturi}")
    private String redirectURI;
    @Value(value="${mosip.iam.module.login_flow.scope:cls}")
    private String scope;
    @Value(value="${mosip.iam.module.login_flow.response_type:code}")
    private String responseType;
    @Value(value="${mosip.iam.authorization_endpoint}")
    private String authorizationEndpoint;
    @Value(value="${mosip.iam.module.admin_realm_id}")
    private String realmID;
    @Value(value="${mosip.iam.token_endpoint}")
    private String tokenEndpoint;
    @Value(value="${auth.server.admin.validate.url}")
    private String validateUrl;
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private ObjectMapper objectMapper;
    private static final String LOG_OUT_FAILED = "log out failed";
    private static final String FAILED = "Failed";
    private static final String SUCCESS = "Success";
    private static final String SUCCESSFULLY_LOGGED_OUT = "successfully loggedout";

    @Override
    public String login(String redirectURI, String state) {
        HashMap<String, String> pathParam = new HashMap<String, String>();
        pathParam.put("realmId", this.realmID);
        UriComponentsBuilder uriComponentsBuilder = UriComponentsBuilder.fromHttpUrl((String)this.authorizationEndpoint);
        uriComponentsBuilder.queryParam("client_id", new Object[]{this.clientID});
        uriComponentsBuilder.queryParam("redirect_uri", new Object[]{this.redirectURI + redirectURI});
        uriComponentsBuilder.queryParam("state", new Object[]{state});
        uriComponentsBuilder.queryParam("response_type", new Object[]{this.responseType});
        uriComponentsBuilder.queryParam("scope", new Object[]{this.scope});
        return uriComponentsBuilder.buildAndExpand(pathParam).toString();
    }

    @Override
    public Cookie createCookie(String authCookie) {
        Cookie cookie = new Cookie(this.authTokenHeader, authCookie);
        cookie.setMaxAge(this.authTokenExpiry);
        cookie.setHttpOnly(true);
        cookie.setSecure(this.isSecureCookie);
        cookie.setPath("/");
        return cookie;
    }

    @Override
    public MosipUserDto valdiateToken(String authToken) {
        MosipUserDto mosipUserDto;
        HttpHeaders headers = new HttpHeaders();
        headers.add("Cookie", this.authTokenHeader + "=" + authToken);
        HttpEntity requestEntity = new HttpEntity((MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.exchange(this.validateUrl, HttpMethod.GET, requestEntity, String.class, new Object[0]);
        if (response == null) {
            throw new ServiceException(Errors.CANNOT_CONNECT_TO_AUTH_SERVICE.getErrorCode(), Errors.CANNOT_CONNECT_TO_AUTH_SERVICE.getErrorMessage());
        }
        String responseBody = (String)response.getBody();
        List validationErrorList = ExceptionUtils.getServiceErrorList((String)responseBody);
        if (!validationErrorList.isEmpty()) {
            throw new AuthRestException(validationErrorList);
        }
        try {
            ResponseWrapper responseObject = (ResponseWrapper)this.objectMapper.readValue((String)response.getBody(), ResponseWrapper.class);
            mosipUserDto = (MosipUserDto)this.objectMapper.readValue(this.objectMapper.writeValueAsString(responseObject.getResponse()), MosipUserDto.class);
        }
        catch (IOException e) {
            throw new ServiceException(Errors.IO_EXCEPTION.getErrorCode(), Errors.IO_EXCEPTION.getErrorMessage());
        }
        return mosipUserDto;
    }

    @Override
    public AccessTokenResponseDTO loginRedirect(String state, String sessionState, String code, String stateCookie, String redirectURI) {
        if (!stateCookie.equals(state)) {
            throw new ClientException(Errors.STATE_EXCEPTION.getErrorCode(), Errors.STATE_EXCEPTION.getErrorMessage());
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        LinkedMultiValueMap map = new LinkedMultiValueMap();
        map.add((Object)"grant_type", (Object)this.loginFlowName);
        map.add((Object)"client_id", (Object)this.clientID);
        map.add((Object)"client_secret", (Object)this.clientSecret);
        map.add((Object)"code", (Object)code);
        map.add((Object)"redirect_uri", (Object)(this.redirectURI + redirectURI));
        HashMap<String, String> pathParam = new HashMap<String, String>();
        pathParam.put("realmId", this.realmID);
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromUriString((String)this.tokenEndpoint);
        HttpEntity entity = new HttpEntity((Object)map, (MultiValueMap)headers);
        ResponseEntity responseEntity = null;
        try {
            responseEntity = this.restTemplate.exchange(uriBuilder.buildAndExpand(pathParam).toUriString(), HttpMethod.POST, entity, String.class, new Object[0]);
        }
        catch (HttpClientErrorException | HttpServerErrorException e) {
            IAMErrorResponseDto keycloakErrorResponseDto = this.parseKeyClockErrorResponse((HttpStatusCodeException)e);
            throw new ServiceException(Errors.ACESSTOKEN_EXCEPTION.getErrorCode(), Errors.ACESSTOKEN_EXCEPTION.getErrorMessage() + " " + keycloakErrorResponseDto.getError_description());
        }
        AccessTokenResponse accessTokenResponse = null;
        try {
            accessTokenResponse = (AccessTokenResponse)this.objectMapper.readValue((String)responseEntity.getBody(), AccessTokenResponse.class);
        }
        catch (IOException exception) {
            throw new ServiceException(Errors.RESPONSE_PARSE_ERROR.getErrorCode(), Errors.RESPONSE_PARSE_ERROR.getErrorMessage() + " " + exception.getMessage());
        }
        AccessTokenResponseDTO accessTokenResponseDTO = new AccessTokenResponseDTO();
        accessTokenResponseDTO.setAccessToken(accessTokenResponse.getAccess_token());
        accessTokenResponseDTO.setExpiresIn(accessTokenResponse.getExpires_in());
        return accessTokenResponseDTO;
    }

    private IAMErrorResponseDto parseKeyClockErrorResponse(HttpStatusCodeException exception) {
        IAMErrorResponseDto keycloakErrorResponseDto = null;
        try {
            keycloakErrorResponseDto = (IAMErrorResponseDto)this.objectMapper.readValue(exception.getResponseBodyAsString(), IAMErrorResponseDto.class);
        }
        catch (IOException e) {
            throw new ServiceException(Errors.RESPONSE_PARSE_ERROR.getErrorCode(), Errors.RESPONSE_PARSE_ERROR.getErrorMessage() + " " + e.getMessage());
        }
        return keycloakErrorResponseDto;
    }

    @Override
    public AuthResponseDto logoutUser(String token) {
        if (EmptyCheckUtils.isNullEmpty((String)token)) {
            throw new AuthenticationServiceException(Errors.INVALID_TOKEN.getErrorMessage());
        }
        HashMap pathparams = new HashMap();
        String issuer = this.getissuer(token);
        ResponseEntity response = null;
        AuthResponseDto authResponseDto = new AuthResponseDto();
        StringBuilder urlBuilder = new StringBuilder().append(issuer).append("/protocol/openid-connect/logout");
        UriComponentsBuilder uriComponentsBuilder = UriComponentsBuilder.fromUriString((String)urlBuilder.toString()).queryParam("id_token_hint", new Object[]{token});
        try {
            response = this.restTemplate.getForEntity(uriComponentsBuilder.buildAndExpand(pathparams).toUriString(), String.class, new Object[0]);
        }
        catch (HttpClientErrorException | HttpServerErrorException e) {
            throw new ServiceException(Errors.REST_EXCEPTION.getErrorCode(), Errors.REST_EXCEPTION.getErrorMessage() + e.getResponseBodyAsString());
        }
        if (response.getStatusCode().is2xxSuccessful()) {
            authResponseDto.setMessage(SUCCESSFULLY_LOGGED_OUT);
            authResponseDto.setStatus(SUCCESS);
        } else {
            authResponseDto.setMessage(LOG_OUT_FAILED);
            authResponseDto.setStatus(FAILED);
        }
        return authResponseDto;
    }

    public String getissuer(String token) {
        DecodedJWT decodedJWT = JWT.decode((String)token);
        return decodedJWT.getClaim("iss").asString();
    }
}

