/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.authcodeflowproxy.api.validator;

import com.auth0.jwk.Jwk;
import com.auth0.jwk.JwkException;
import com.auth0.jwk.UrlJwkProvider;
import com.auth0.jwt.JWT;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.exceptions.SignatureVerificationException;
import com.auth0.jwt.impl.NullClaim;
import com.auth0.jwt.interfaces.Claim;
import com.auth0.jwt.interfaces.DecodedJWT;
import io.mosip.kernel.core.util.DateUtils2;
import io.mosip.kernel.openid.bridge.api.constants.AuthErrorCode;
import io.mosip.kernel.openid.bridge.api.constants.Errors;
import io.mosip.kernel.openid.bridge.api.exception.ServiceException;
import jakarta.annotation.PostConstruct;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.PublicKey;
import java.security.interfaces.RSAPublicKey;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@Component
public class ValidateTokenUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(ValidateTokenUtil.class);
    private Map<String, PublicKey> publicKeys = new HashMap<String, PublicKey>();
    @Value(value="${mosip.iam.certs_endpoint:}")
    private String certsPathUrl;
    @Value(value="${auth.server.admin.issuer.domain.validate:true}")
    private boolean validateIssuerDomain;
    @Value(value="${auth.server.admin.audience.claim.validate:true}")
    private boolean validateAudClaim;
    private List<String> allowedAudience;
    @Autowired
    private Environment environment;

    @PostConstruct
    private void init() {
        String applName = this.getApplicationName();
        this.allowedAudience = (List)this.environment.getProperty("auth.server.admin.allowed.audience." + applName, List.class, (Object)((List)this.environment.getProperty("auth.server.admin.allowed.audience", List.class, (Object)Collections.EMPTY_LIST)));
    }

    private String getApplicationName() {
        String appNames = this.environment.getProperty("spring.application.name");
        if (appNames != null && !appNames.isEmpty()) {
            List appNamesList = Stream.of(appNames.split(",")).collect(Collectors.toList());
            return (String)appNamesList.get(0);
        }
        throw new RuntimeException("property spring.application.name not found");
    }

    public void validateToken(String accessToken) {
        if (!((Boolean)this.isTokenValid(accessToken).getKey()).booleanValue()) {
            throw new ServiceException(Errors.INVALID_TOKEN.getErrorCode(), Errors.INVALID_TOKEN.getErrorMessage());
        }
    }

    public ImmutablePair<Boolean, AuthErrorCode> isTokenValid(String jwtToken) {
        return this.isTokenValid(JWT.decode((String)jwtToken));
    }

    public ImmutablePair<Boolean, AuthErrorCode> isTokenValid(DecodedJWT decodedJWT) {
        PublicKey publicKey = this.getPublicKey(decodedJWT);
        LocalDateTime expiryTime = DateUtils2.convertUTCToLocalDateTime((String)DateUtils2.getUTCTimeFromDate((Date)decodedJWT.getExpiresAt()));
        String userName = decodedJWT.getClaim("preferred_username").asString();
        if (!DateUtils2.before((LocalDateTime)DateUtils2.getUTCCurrentDateTime(), (LocalDateTime)expiryTime)) {
            LOGGER.error("Provided Auth Token expired. Throwing Authentication Exception. UserName: " + userName);
            return ImmutablePair.of((Object)Boolean.FALSE, (Object)AuthErrorCode.UNAUTHORIZED);
        }
        if (this.validateIssuerDomain && !this.getTokenIssuerDomain(decodedJWT)) {
            LOGGER.error("Provided Auth Token Issue domain does not match. Throwing Authentication Exception. UserName: " + userName);
            return ImmutablePair.of((Object)Boolean.FALSE, (Object)AuthErrorCode.UNAUTHORIZED);
        }
        ImmutablePair<Boolean, AuthErrorCode> signatureVerificationResult = this.verifyJWTSignagure(decodedJWT);
        if (!((Boolean)signatureVerificationResult.getLeft()).booleanValue()) {
            return signatureVerificationResult;
        }
        if (this.validateAudClaim && !this.validateAudience(decodedJWT)) {
            LOGGER.error("Provided Client Id does not match with Aud/AZP. Throwing Authorizaion Exception. UserName: " + userName);
            return ImmutablePair.of((Object)Boolean.FALSE, (Object)AuthErrorCode.FORBIDDEN);
        }
        return ImmutablePair.of((Object)Boolean.TRUE, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean validateAudience(DecodedJWT decodedJWT) {
        List tokenAudience = decodedJWT.getAudience();
        if (tokenAudience != null) {
            if (tokenAudience.stream().anyMatch(this.allowedAudience::contains)) {
                return true;
            }
        }
        boolean bl = false;
        boolean matchFound = bl;
        if (matchFound) return matchFound;
        Claim azp = decodedJWT.getClaim("azp");
        if (azp == null) return false;
        if (azp instanceof NullClaim) return false;
        if (!this.allowedAudience.stream().anyMatch(azp.asString()::equalsIgnoreCase)) return false;
        return true;
    }

    private boolean getTokenIssuerDomain(DecodedJWT decodedJWT) {
        String domain = decodedJWT.getClaim("iss").asString();
        try {
            String tokenHost = new URI(domain).getHost();
            return tokenHost.equalsIgnoreCase(new URI(this.certsPathUrl).getHost());
        }
        catch (URISyntaxException synExp) {
            LOGGER.error("Unable to parse domain from issuer.", (Throwable)synExp);
            return false;
        }
    }

    public PublicKey getPublicKey(DecodedJWT decodedJWT) {
        String userName = decodedJWT.getClaim("preferred_username").asString();
        LOGGER.info("offline verification for environment profile. UserName: " + userName);
        String keyId = decodedJWT.getKeyId();
        PublicKey publicKey = this.publicKeys.get(keyId);
        if (Objects.isNull(publicKey)) {
            publicKey = this.getIssuerPublicKey(keyId);
            this.publicKeys.put(keyId, publicKey);
        }
        return publicKey;
    }

    public ImmutablePair<Boolean, AuthErrorCode> verifyJWTSignagure(DecodedJWT decodedJWT) {
        try {
            String tokenAlgo = decodedJWT.getAlgorithm();
            PublicKey publicKey = this.getPublicKey(decodedJWT);
            Algorithm algorithm = this.getVerificationAlgorithm(tokenAlgo, publicKey);
            algorithm.verify(decodedJWT);
        }
        catch (SignatureVerificationException signatureException) {
            LOGGER.error("Signature validation failed for User Info, Throwing Authentication Exception.", (Throwable)signatureException);
            return ImmutablePair.of((Object)Boolean.FALSE, (Object)AuthErrorCode.UNAUTHORIZED);
        }
        return ImmutablePair.of((Object)Boolean.TRUE, null);
    }

    private PublicKey getIssuerPublicKey(String keyId) {
        try {
            URI uri = new URI(this.certsPathUrl).normalize();
            UrlJwkProvider provider = new UrlJwkProvider(uri.toURL());
            Jwk jwk = provider.get(keyId);
            return jwk.getPublicKey();
        }
        catch (JwkException | MalformedURLException | URISyntaxException e) {
            LOGGER.error("Error downloading Public key from server".concat(e.getMessage()));
            return null;
        }
    }

    private Algorithm getVerificationAlgorithm(String tokenAlgo, PublicKey publicKey) {
        switch (tokenAlgo) {
            case "RS256": {
                return Algorithm.RSA256((RSAPublicKey)((RSAPublicKey)publicKey), null);
            }
            case "RS384": {
                return Algorithm.RSA384((RSAPublicKey)((RSAPublicKey)publicKey), null);
            }
            case "RS512": {
                return Algorithm.RSA512((RSAPublicKey)((RSAPublicKey)publicKey), null);
            }
        }
        return Algorithm.RSA256((RSAPublicKey)((RSAPublicKey)publicKey), null);
    }
}

