/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.catapult.builders;

import io.nem.symbol.catapult.builders.AccountMetadataTransactionBodyBuilder;
import io.nem.symbol.catapult.builders.AmountDto;
import io.nem.symbol.catapult.builders.EntityTypeDto;
import io.nem.symbol.catapult.builders.GeneratorUtils;
import io.nem.symbol.catapult.builders.KeyDto;
import io.nem.symbol.catapult.builders.NetworkTypeDto;
import io.nem.symbol.catapult.builders.Serializer;
import io.nem.symbol.catapult.builders.SignatureDto;
import io.nem.symbol.catapult.builders.TimestampDto;
import io.nem.symbol.catapult.builders.TransactionBuilder;
import java.io.DataInputStream;
import java.nio.ByteBuffer;

public class AccountMetadataTransactionBuilder
extends TransactionBuilder
implements Serializer {
    private final AccountMetadataTransactionBodyBuilder accountMetadataTransactionBody;

    protected AccountMetadataTransactionBuilder(DataInputStream stream) {
        super(stream);
        try {
            this.accountMetadataTransactionBody = AccountMetadataTransactionBodyBuilder.loadFromBinary(stream);
        }
        catch (Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    public static AccountMetadataTransactionBuilder loadFromBinary(DataInputStream stream) {
        return new AccountMetadataTransactionBuilder(stream);
    }

    protected AccountMetadataTransactionBuilder(SignatureDto signature, KeyDto signerPublicKey, byte version, NetworkTypeDto network, EntityTypeDto type, AmountDto fee, TimestampDto deadline, KeyDto targetPublicKey, long scopedMetadataKey, short valueSizeDelta, ByteBuffer value) {
        super(signature, signerPublicKey, version, network, type, fee, deadline);
        GeneratorUtils.notNull(signature, "signature is null", new Object[0]);
        GeneratorUtils.notNull(signerPublicKey, "signerPublicKey is null", new Object[0]);
        GeneratorUtils.notNull(version, "version is null", new Object[0]);
        GeneratorUtils.notNull(network, "network is null", new Object[0]);
        GeneratorUtils.notNull(type, "type is null", new Object[0]);
        GeneratorUtils.notNull(fee, "fee is null", new Object[0]);
        GeneratorUtils.notNull(deadline, "deadline is null", new Object[0]);
        GeneratorUtils.notNull(targetPublicKey, "targetPublicKey is null", new Object[0]);
        GeneratorUtils.notNull(scopedMetadataKey, "scopedMetadataKey is null", new Object[0]);
        GeneratorUtils.notNull(valueSizeDelta, "valueSizeDelta is null", new Object[0]);
        GeneratorUtils.notNull(value, "value is null", new Object[0]);
        this.accountMetadataTransactionBody = new AccountMetadataTransactionBodyBuilder(targetPublicKey, scopedMetadataKey, valueSizeDelta, value);
    }

    public static AccountMetadataTransactionBuilder create(SignatureDto signature, KeyDto signerPublicKey, byte version, NetworkTypeDto network, EntityTypeDto type, AmountDto fee, TimestampDto deadline, KeyDto targetPublicKey, long scopedMetadataKey, short valueSizeDelta, ByteBuffer value) {
        return new AccountMetadataTransactionBuilder(signature, signerPublicKey, version, network, type, fee, deadline, targetPublicKey, scopedMetadataKey, valueSizeDelta, value);
    }

    public KeyDto getTargetPublicKey() {
        return this.accountMetadataTransactionBody.getTargetPublicKey();
    }

    public long getScopedMetadataKey() {
        return this.accountMetadataTransactionBody.getScopedMetadataKey();
    }

    public short getValueSizeDelta() {
        return this.accountMetadataTransactionBody.getValueSizeDelta();
    }

    public ByteBuffer getValue() {
        return this.accountMetadataTransactionBody.getValue();
    }

    @Override
    public int getSize() {
        int size = super.getSize();
        return size += this.accountMetadataTransactionBody.getSize();
    }

    @Override
    public AccountMetadataTransactionBodyBuilder getBody() {
        return this.accountMetadataTransactionBody;
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            byte[] superBytes = super.serialize();
            dataOutputStream.write(superBytes, 0, superBytes.length);
            GeneratorUtils.writeEntity(dataOutputStream, this.accountMetadataTransactionBody);
        });
    }
}

