/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.catapult.builders;

import io.nem.symbol.catapult.builders.AccountRestrictionAddressValueBuilder;
import io.nem.symbol.catapult.builders.AccountRestrictionFlagsDto;
import io.nem.symbol.catapult.builders.AccountRestrictionMosaicValueBuilder;
import io.nem.symbol.catapult.builders.AccountRestrictionTransactionTypeValueBuilder;
import io.nem.symbol.catapult.builders.GeneratorUtils;
import io.nem.symbol.catapult.builders.Serializer;
import java.io.DataInputStream;
import java.util.EnumSet;

public class AccountRestrictionsInfoBuilder
implements Serializer {
    private final EnumSet<AccountRestrictionFlagsDto> restrictionFlags;
    private AccountRestrictionAddressValueBuilder addressRestrictions;
    private AccountRestrictionMosaicValueBuilder mosaicIdRestrictions;
    private AccountRestrictionTransactionTypeValueBuilder transactionTypeRestrictions;

    protected AccountRestrictionsInfoBuilder(DataInputStream stream) {
        try {
            this.restrictionFlags = GeneratorUtils.toSet(AccountRestrictionFlagsDto.class, Short.reverseBytes(stream.readShort()));
            if (this.restrictionFlags.contains(AccountRestrictionFlagsDto.ADDRESS)) {
                this.addressRestrictions = AccountRestrictionAddressValueBuilder.loadFromBinary(stream);
            }
            if (this.restrictionFlags.contains(AccountRestrictionFlagsDto.MOSAIC_ID)) {
                this.mosaicIdRestrictions = AccountRestrictionMosaicValueBuilder.loadFromBinary(stream);
            }
            if (this.restrictionFlags.contains(AccountRestrictionFlagsDto.TRANSACTION_TYPE)) {
                this.transactionTypeRestrictions = AccountRestrictionTransactionTypeValueBuilder.loadFromBinary(stream);
            }
        }
        catch (Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    public static AccountRestrictionsInfoBuilder loadFromBinary(DataInputStream stream) {
        return new AccountRestrictionsInfoBuilder(stream);
    }

    protected AccountRestrictionsInfoBuilder(EnumSet<AccountRestrictionFlagsDto> restrictionFlags, AccountRestrictionAddressValueBuilder addressRestrictions, AccountRestrictionMosaicValueBuilder mosaicIdRestrictions, AccountRestrictionTransactionTypeValueBuilder transactionTypeRestrictions) {
        GeneratorUtils.notNull(restrictionFlags, "restrictionFlags is null", new Object[0]);
        if (restrictionFlags.contains(AccountRestrictionFlagsDto.ADDRESS)) {
            GeneratorUtils.notNull(addressRestrictions, "addressRestrictions is null", new Object[0]);
        }
        if (restrictionFlags.contains(AccountRestrictionFlagsDto.MOSAIC_ID)) {
            GeneratorUtils.notNull(mosaicIdRestrictions, "mosaicIdRestrictions is null", new Object[0]);
        }
        if (restrictionFlags.contains(AccountRestrictionFlagsDto.TRANSACTION_TYPE)) {
            GeneratorUtils.notNull(transactionTypeRestrictions, "transactionTypeRestrictions is null", new Object[0]);
        }
        this.restrictionFlags = restrictionFlags;
        this.addressRestrictions = addressRestrictions;
        this.mosaicIdRestrictions = mosaicIdRestrictions;
        this.transactionTypeRestrictions = transactionTypeRestrictions;
    }

    public static AccountRestrictionsInfoBuilder create(EnumSet<AccountRestrictionFlagsDto> restrictionFlags, AccountRestrictionAddressValueBuilder addressRestrictions, AccountRestrictionMosaicValueBuilder mosaicIdRestrictions, AccountRestrictionTransactionTypeValueBuilder transactionTypeRestrictions) {
        return new AccountRestrictionsInfoBuilder(restrictionFlags, addressRestrictions, mosaicIdRestrictions, transactionTypeRestrictions);
    }

    public EnumSet<AccountRestrictionFlagsDto> getRestrictionFlags() {
        return this.restrictionFlags;
    }

    public AccountRestrictionAddressValueBuilder getAddressRestrictions() {
        if (!this.restrictionFlags.contains(AccountRestrictionFlagsDto.ADDRESS)) {
            throw new IllegalStateException("restrictionFlags is not set to ADDRESS.");
        }
        return this.addressRestrictions;
    }

    public AccountRestrictionMosaicValueBuilder getMosaicIdRestrictions() {
        if (!this.restrictionFlags.contains(AccountRestrictionFlagsDto.MOSAIC_ID)) {
            throw new IllegalStateException("restrictionFlags is not set to MOSAIC_ID.");
        }
        return this.mosaicIdRestrictions;
    }

    public AccountRestrictionTransactionTypeValueBuilder getTransactionTypeRestrictions() {
        if (!this.restrictionFlags.contains(AccountRestrictionFlagsDto.TRANSACTION_TYPE)) {
            throw new IllegalStateException("restrictionFlags is not set to TRANSACTION_TYPE.");
        }
        return this.transactionTypeRestrictions;
    }

    @Override
    public int getSize() {
        int size = 0;
        size += AccountRestrictionFlagsDto.values()[0].getSize();
        if (this.restrictionFlags.contains(AccountRestrictionFlagsDto.ADDRESS)) {
            size += this.addressRestrictions.getSize();
        }
        if (this.restrictionFlags.contains(AccountRestrictionFlagsDto.MOSAIC_ID)) {
            size += this.mosaicIdRestrictions.getSize();
        }
        if (this.restrictionFlags.contains(AccountRestrictionFlagsDto.TRANSACTION_TYPE)) {
            size += this.transactionTypeRestrictions.getSize();
        }
        return size;
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            dataOutputStream.writeShort(Short.reverseBytes((byte)GeneratorUtils.toLong(AccountRestrictionFlagsDto.class, this.restrictionFlags)));
            if (this.restrictionFlags.contains(AccountRestrictionFlagsDto.ADDRESS)) {
                GeneratorUtils.writeEntity(dataOutputStream, this.addressRestrictions);
            }
            if (this.restrictionFlags.contains(AccountRestrictionFlagsDto.MOSAIC_ID)) {
                GeneratorUtils.writeEntity(dataOutputStream, this.mosaicIdRestrictions);
            }
            if (this.restrictionFlags.contains(AccountRestrictionFlagsDto.TRANSACTION_TYPE)) {
                GeneratorUtils.writeEntity(dataOutputStream, this.transactionTypeRestrictions);
            }
        });
    }
}

