/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.catapult.builders;

import io.nem.symbol.catapult.builders.GeneratorUtils;
import io.nem.symbol.catapult.builders.KeyDto;
import io.nem.symbol.catapult.builders.Serializer;
import io.nem.symbol.catapult.builders.SignatureDto;
import java.io.DataInputStream;

public class CosignatureBuilder
implements Serializer {
    private final KeyDto signerPublicKey;
    private final SignatureDto signature;

    protected CosignatureBuilder(DataInputStream stream) {
        try {
            this.signerPublicKey = KeyDto.loadFromBinary(stream);
            this.signature = SignatureDto.loadFromBinary(stream);
        }
        catch (Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    public static CosignatureBuilder loadFromBinary(DataInputStream stream) {
        return new CosignatureBuilder(stream);
    }

    protected CosignatureBuilder(KeyDto signerPublicKey, SignatureDto signature) {
        GeneratorUtils.notNull(signerPublicKey, "signerPublicKey is null", new Object[0]);
        GeneratorUtils.notNull(signature, "signature is null", new Object[0]);
        this.signerPublicKey = signerPublicKey;
        this.signature = signature;
    }

    public static CosignatureBuilder create(KeyDto signerPublicKey, SignatureDto signature) {
        return new CosignatureBuilder(signerPublicKey, signature);
    }

    public KeyDto getSignerPublicKey() {
        return this.signerPublicKey;
    }

    public SignatureDto getSignature() {
        return this.signature;
    }

    @Override
    public int getSize() {
        int size = 0;
        size += this.signerPublicKey.getSize();
        return size += this.signature.getSize();
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            GeneratorUtils.writeEntity(dataOutputStream, this.signerPublicKey);
            GeneratorUtils.writeEntity(dataOutputStream, this.signature);
        });
    }
}

