/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.catapult.builders;

import io.nem.symbol.catapult.builders.EmbeddedTransactionHeaderBuilder;
import io.nem.symbol.catapult.builders.EntityTypeDto;
import io.nem.symbol.catapult.builders.GeneratorUtils;
import io.nem.symbol.catapult.builders.KeyDto;
import io.nem.symbol.catapult.builders.NetworkTypeDto;
import io.nem.symbol.catapult.builders.Serializer;
import java.io.DataInputStream;

public class EmbeddedTransactionBuilder
extends EmbeddedTransactionHeaderBuilder
implements Serializer {
    private final KeyDto signerPublicKey;
    private final int entityBody_Reserved1;
    private final byte version;
    private final NetworkTypeDto network;
    private final EntityTypeDto type;

    protected EmbeddedTransactionBuilder(DataInputStream stream) {
        super(stream);
        try {
            this.signerPublicKey = KeyDto.loadFromBinary(stream);
            this.entityBody_Reserved1 = Integer.reverseBytes(stream.readInt());
            this.version = stream.readByte();
            this.network = NetworkTypeDto.loadFromBinary(stream);
            this.type = EntityTypeDto.loadFromBinary(stream);
        }
        catch (Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    public static EmbeddedTransactionBuilder loadFromBinary(DataInputStream stream) {
        return new EmbeddedTransactionBuilder(stream);
    }

    protected EmbeddedTransactionBuilder(KeyDto signerPublicKey, byte version, NetworkTypeDto network, EntityTypeDto type) {
        GeneratorUtils.notNull(signerPublicKey, "signerPublicKey is null", new Object[0]);
        GeneratorUtils.notNull(version, "version is null", new Object[0]);
        GeneratorUtils.notNull(network, "network is null", new Object[0]);
        GeneratorUtils.notNull(type, "type is null", new Object[0]);
        this.signerPublicKey = signerPublicKey;
        this.entityBody_Reserved1 = 0;
        this.version = version;
        this.network = network;
        this.type = type;
    }

    public static EmbeddedTransactionBuilder create(KeyDto signerPublicKey, byte version, NetworkTypeDto network, EntityTypeDto type) {
        return new EmbeddedTransactionBuilder(signerPublicKey, version, network, type);
    }

    public KeyDto getSignerPublicKey() {
        return this.signerPublicKey;
    }

    public int getEntityBody_Reserved1() {
        return this.entityBody_Reserved1;
    }

    public byte getVersion() {
        return this.version;
    }

    public NetworkTypeDto getNetwork() {
        return this.network;
    }

    public EntityTypeDto getType() {
        return this.type;
    }

    @Override
    public int getSize() {
        int size = super.getSize();
        size += this.signerPublicKey.getSize();
        size += 4;
        ++size;
        size += this.network.getSize();
        return size += this.type.getSize();
    }

    public Serializer getBody() {
        return null;
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            byte[] superBytes = super.serialize();
            dataOutputStream.write(superBytes, 0, superBytes.length);
            GeneratorUtils.writeEntity(dataOutputStream, this.signerPublicKey);
            dataOutputStream.writeInt(Integer.reverseBytes(this.getEntityBody_Reserved1()));
            dataOutputStream.writeByte(this.getVersion());
            GeneratorUtils.writeEntity(dataOutputStream, this.network);
            GeneratorUtils.writeEntity(dataOutputStream, this.type);
        });
    }
}

