/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.catapult.builders;

import io.nem.symbol.catapult.builders.GeneratorUtils;
import io.nem.symbol.catapult.builders.GlobalKeyValueSetBuilder;
import io.nem.symbol.catapult.builders.MosaicIdDto;
import io.nem.symbol.catapult.builders.Serializer;
import java.io.DataInputStream;

public class MosaicGlobalRestrictionEntryBuilder
implements Serializer {
    private final MosaicIdDto mosaicId;
    private final GlobalKeyValueSetBuilder keyPairs;

    protected MosaicGlobalRestrictionEntryBuilder(DataInputStream stream) {
        try {
            this.mosaicId = MosaicIdDto.loadFromBinary(stream);
            this.keyPairs = GlobalKeyValueSetBuilder.loadFromBinary(stream);
        }
        catch (Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    public static MosaicGlobalRestrictionEntryBuilder loadFromBinary(DataInputStream stream) {
        return new MosaicGlobalRestrictionEntryBuilder(stream);
    }

    protected MosaicGlobalRestrictionEntryBuilder(MosaicIdDto mosaicId, GlobalKeyValueSetBuilder keyPairs) {
        GeneratorUtils.notNull(mosaicId, "mosaicId is null", new Object[0]);
        GeneratorUtils.notNull(keyPairs, "keyPairs is null", new Object[0]);
        this.mosaicId = mosaicId;
        this.keyPairs = keyPairs;
    }

    public static MosaicGlobalRestrictionEntryBuilder create(MosaicIdDto mosaicId, GlobalKeyValueSetBuilder keyPairs) {
        return new MosaicGlobalRestrictionEntryBuilder(mosaicId, keyPairs);
    }

    public MosaicIdDto getMosaicId() {
        return this.mosaicId;
    }

    public GlobalKeyValueSetBuilder getKeyPairs() {
        return this.keyPairs;
    }

    @Override
    public int getSize() {
        int size = 0;
        size += this.mosaicId.getSize();
        return size += this.keyPairs.getSize();
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            GeneratorUtils.writeEntity(dataOutputStream, this.mosaicId);
            GeneratorUtils.writeEntity(dataOutputStream, this.keyPairs);
        });
    }
}

