/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.catapult.builders;

import io.nem.symbol.catapult.builders.AmountDto;
import io.nem.symbol.catapult.builders.EntityTypeDto;
import io.nem.symbol.catapult.builders.GeneratorUtils;
import io.nem.symbol.catapult.builders.KeyDto;
import io.nem.symbol.catapult.builders.LinkActionDto;
import io.nem.symbol.catapult.builders.NetworkTypeDto;
import io.nem.symbol.catapult.builders.NodeKeyLinkTransactionBodyBuilder;
import io.nem.symbol.catapult.builders.Serializer;
import io.nem.symbol.catapult.builders.SignatureDto;
import io.nem.symbol.catapult.builders.TimestampDto;
import io.nem.symbol.catapult.builders.TransactionBuilder;
import java.io.DataInputStream;

public class NodeKeyLinkTransactionBuilder
extends TransactionBuilder
implements Serializer {
    private final NodeKeyLinkTransactionBodyBuilder nodeKeyLinkTransactionBody;

    protected NodeKeyLinkTransactionBuilder(DataInputStream stream) {
        super(stream);
        try {
            this.nodeKeyLinkTransactionBody = NodeKeyLinkTransactionBodyBuilder.loadFromBinary(stream);
        }
        catch (Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    public static NodeKeyLinkTransactionBuilder loadFromBinary(DataInputStream stream) {
        return new NodeKeyLinkTransactionBuilder(stream);
    }

    protected NodeKeyLinkTransactionBuilder(SignatureDto signature, KeyDto signerPublicKey, byte version, NetworkTypeDto network, EntityTypeDto type, AmountDto fee, TimestampDto deadline, KeyDto linkedPublicKey, LinkActionDto linkAction) {
        super(signature, signerPublicKey, version, network, type, fee, deadline);
        GeneratorUtils.notNull(signature, "signature is null", new Object[0]);
        GeneratorUtils.notNull(signerPublicKey, "signerPublicKey is null", new Object[0]);
        GeneratorUtils.notNull(version, "version is null", new Object[0]);
        GeneratorUtils.notNull(network, "network is null", new Object[0]);
        GeneratorUtils.notNull(type, "type is null", new Object[0]);
        GeneratorUtils.notNull(fee, "fee is null", new Object[0]);
        GeneratorUtils.notNull(deadline, "deadline is null", new Object[0]);
        GeneratorUtils.notNull(linkedPublicKey, "linkedPublicKey is null", new Object[0]);
        GeneratorUtils.notNull(linkAction, "linkAction is null", new Object[0]);
        this.nodeKeyLinkTransactionBody = new NodeKeyLinkTransactionBodyBuilder(linkedPublicKey, linkAction);
    }

    public static NodeKeyLinkTransactionBuilder create(SignatureDto signature, KeyDto signerPublicKey, byte version, NetworkTypeDto network, EntityTypeDto type, AmountDto fee, TimestampDto deadline, KeyDto linkedPublicKey, LinkActionDto linkAction) {
        return new NodeKeyLinkTransactionBuilder(signature, signerPublicKey, version, network, type, fee, deadline, linkedPublicKey, linkAction);
    }

    public KeyDto getLinkedPublicKey() {
        return this.nodeKeyLinkTransactionBody.getLinkedPublicKey();
    }

    public LinkActionDto getLinkAction() {
        return this.nodeKeyLinkTransactionBody.getLinkAction();
    }

    @Override
    public int getSize() {
        int size = super.getSize();
        return size += this.nodeKeyLinkTransactionBody.getSize();
    }

    @Override
    public NodeKeyLinkTransactionBodyBuilder getBody() {
        return this.nodeKeyLinkTransactionBody;
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            byte[] superBytes = super.serialize();
            dataOutputStream.write(superBytes, 0, superBytes.length);
            GeneratorUtils.writeEntity(dataOutputStream, this.nodeKeyLinkTransactionBody);
        });
    }
}

