/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.catapult.builders;

import io.nem.symbol.catapult.builders.GeneratorUtils;
import io.nem.symbol.catapult.builders.KeyDto;
import io.nem.symbol.catapult.builders.NamespaceAliasTypeDto;
import io.nem.symbol.catapult.builders.NamespaceIdDto;
import io.nem.symbol.catapult.builders.NamespaceLifetimeBuilder;
import io.nem.symbol.catapult.builders.NamespacePathBuilder;
import io.nem.symbol.catapult.builders.Serializer;
import java.io.DataInputStream;
import java.util.List;

public class RootNamespaceHistoryBuilder
implements Serializer {
    private final NamespaceIdDto id;
    private final KeyDto ownerPublicKey;
    private final NamespaceLifetimeBuilder lifetime;
    private final NamespaceAliasTypeDto rootAlias;
    private final List<NamespacePathBuilder> paths;

    protected RootNamespaceHistoryBuilder(DataInputStream stream) {
        try {
            this.id = NamespaceIdDto.loadFromBinary(stream);
            this.ownerPublicKey = KeyDto.loadFromBinary(stream);
            this.lifetime = NamespaceLifetimeBuilder.loadFromBinary(stream);
            this.rootAlias = NamespaceAliasTypeDto.loadFromBinary(stream);
            long childrenCount = Long.reverseBytes(stream.readLong());
            this.paths = GeneratorUtils.loadFromBinaryArray(NamespacePathBuilder::loadFromBinary, stream, childrenCount);
        }
        catch (Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    public static RootNamespaceHistoryBuilder loadFromBinary(DataInputStream stream) {
        return new RootNamespaceHistoryBuilder(stream);
    }

    protected RootNamespaceHistoryBuilder(NamespaceIdDto id, KeyDto ownerPublicKey, NamespaceLifetimeBuilder lifetime, NamespaceAliasTypeDto rootAlias, List<NamespacePathBuilder> paths) {
        GeneratorUtils.notNull(id, "id is null", new Object[0]);
        GeneratorUtils.notNull(ownerPublicKey, "ownerPublicKey is null", new Object[0]);
        GeneratorUtils.notNull(lifetime, "lifetime is null", new Object[0]);
        GeneratorUtils.notNull(rootAlias, "rootAlias is null", new Object[0]);
        GeneratorUtils.notNull(paths, "paths is null", new Object[0]);
        this.id = id;
        this.ownerPublicKey = ownerPublicKey;
        this.lifetime = lifetime;
        this.rootAlias = rootAlias;
        this.paths = paths;
    }

    public static RootNamespaceHistoryBuilder create(NamespaceIdDto id, KeyDto ownerPublicKey, NamespaceLifetimeBuilder lifetime, NamespaceAliasTypeDto rootAlias, List<NamespacePathBuilder> paths) {
        return new RootNamespaceHistoryBuilder(id, ownerPublicKey, lifetime, rootAlias, paths);
    }

    public NamespaceIdDto getId() {
        return this.id;
    }

    public KeyDto getOwnerPublicKey() {
        return this.ownerPublicKey;
    }

    public NamespaceLifetimeBuilder getLifetime() {
        return this.lifetime;
    }

    public NamespaceAliasTypeDto getRootAlias() {
        return this.rootAlias;
    }

    public List<NamespacePathBuilder> getPaths() {
        return this.paths;
    }

    @Override
    public int getSize() {
        int size = 0;
        size += this.id.getSize();
        size += this.ownerPublicKey.getSize();
        size += this.lifetime.getSize();
        size += this.rootAlias.getSize();
        size += 8;
        return size += this.paths.stream().mapToInt(o -> o.getSize()).sum();
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            GeneratorUtils.writeEntity(dataOutputStream, this.id);
            GeneratorUtils.writeEntity(dataOutputStream, this.ownerPublicKey);
            GeneratorUtils.writeEntity(dataOutputStream, this.lifetime);
            GeneratorUtils.writeEntity(dataOutputStream, this.rootAlias);
            dataOutputStream.writeLong(Long.reverseBytes(GeneratorUtils.getSize(this.getPaths())));
            GeneratorUtils.writeList(dataOutputStream, this.paths);
        });
    }
}

