/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.catapult.builders;

import io.nem.symbol.catapult.builders.GeneratorUtils;
import io.nem.symbol.catapult.builders.Serializer;
import java.io.DataInputStream;

public enum AccountStateFormatDto implements Serializer
{
    REGULAR(0),
    HIGH_VALUE(1);

    private final byte value;

    private AccountStateFormatDto(byte value) {
        this.value = value;
    }

    public static AccountStateFormatDto rawValueOf(byte value) {
        for (AccountStateFormatDto current : AccountStateFormatDto.values()) {
            if (value != current.value) continue;
            return current;
        }
        throw new IllegalArgumentException(value + " was not a backing value for AccountStateFormatDto.");
    }

    @Override
    public int getSize() {
        return 1;
    }

    public byte getValue() {
        return this.value;
    }

    public static AccountStateFormatDto loadFromBinary(DataInputStream stream) {
        try {
            byte streamValue = stream.readByte();
            return AccountStateFormatDto.rawValueOf(streamValue);
        }
        catch (Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> dataOutputStream.writeByte(this.value));
    }
}

