/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.catapult.builders;

import io.nem.symbol.catapult.builders.GeneratorUtils;
import io.nem.symbol.catapult.builders.NamespaceAliasBuilder;
import io.nem.symbol.catapult.builders.Serializer;
import java.io.DataInputStream;
import java.nio.ByteBuffer;

public class NamespacePathBuilder
implements Serializer {
    private final ByteBuffer path;
    private final NamespaceAliasBuilder alias;

    protected NamespacePathBuilder(DataInputStream stream) {
        try {
            byte pathSize = stream.readByte();
            this.path = GeneratorUtils.readByteBuffer(stream, pathSize);
            this.alias = NamespaceAliasBuilder.loadFromBinary(stream);
        }
        catch (Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    public static NamespacePathBuilder loadFromBinary(DataInputStream stream) {
        return new NamespacePathBuilder(stream);
    }

    protected NamespacePathBuilder(ByteBuffer path, NamespaceAliasBuilder alias) {
        GeneratorUtils.notNull(path, "path is null", new Object[0]);
        GeneratorUtils.notNull(alias, "alias is null", new Object[0]);
        this.path = path;
        this.alias = alias;
    }

    public static NamespacePathBuilder create(ByteBuffer path, NamespaceAliasBuilder alias) {
        return new NamespacePathBuilder(path, alias);
    }

    public ByteBuffer getPath() {
        return this.path;
    }

    public NamespaceAliasBuilder getAlias() {
        return this.alias;
    }

    @Override
    public int getSize() {
        int size = 0;
        ++size;
        size += this.path.array().length;
        return size += this.alias.getSize();
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            dataOutputStream.writeByte((byte)GeneratorUtils.getSize(this.getPath()));
            dataOutputStream.write(this.path.array(), 0, this.path.array().length);
            GeneratorUtils.writeEntity(dataOutputStream, this.alias);
        });
    }
}

