/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.catapult.builders;

import io.nem.symbol.catapult.builders.GeneratorUtils;
import io.nem.symbol.catapult.builders.KeyDto;
import io.nem.symbol.catapult.builders.LinkActionDto;
import io.nem.symbol.catapult.builders.Serializer;
import java.io.DataInputStream;

public class AccountKeyLinkTransactionBodyBuilder
implements Serializer {
    private final KeyDto linkedPublicKey;
    private final LinkActionDto linkAction;

    protected AccountKeyLinkTransactionBodyBuilder(DataInputStream stream) {
        try {
            this.linkedPublicKey = KeyDto.loadFromBinary(stream);
            this.linkAction = LinkActionDto.loadFromBinary(stream);
        }
        catch (Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    public static AccountKeyLinkTransactionBodyBuilder loadFromBinary(DataInputStream stream) {
        return new AccountKeyLinkTransactionBodyBuilder(stream);
    }

    protected AccountKeyLinkTransactionBodyBuilder(KeyDto linkedPublicKey, LinkActionDto linkAction) {
        GeneratorUtils.notNull(linkedPublicKey, "linkedPublicKey is null", new Object[0]);
        GeneratorUtils.notNull(linkAction, "linkAction is null", new Object[0]);
        this.linkedPublicKey = linkedPublicKey;
        this.linkAction = linkAction;
    }

    public static AccountKeyLinkTransactionBodyBuilder create(KeyDto linkedPublicKey, LinkActionDto linkAction) {
        return new AccountKeyLinkTransactionBodyBuilder(linkedPublicKey, linkAction);
    }

    public KeyDto getLinkedPublicKey() {
        return this.linkedPublicKey;
    }

    public LinkActionDto getLinkAction() {
        return this.linkAction;
    }

    @Override
    public int getSize() {
        int size = 0;
        size += this.linkedPublicKey.getSize();
        return size += this.linkAction.getSize();
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            GeneratorUtils.writeEntity(dataOutputStream, this.linkedPublicKey);
            GeneratorUtils.writeEntity(dataOutputStream, this.linkAction);
        });
    }
}

