/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.catapult.builders;

import io.nem.symbol.catapult.builders.GeneratorUtils;
import io.nem.symbol.catapult.builders.Serializer;
import java.io.DataInputStream;

public enum AccountTypeDto implements Serializer
{
    UNLINKED(0),
    MAIN(1),
    REMOTE(2),
    REMOTE_UNLINKED(3);

    private final byte value;

    private AccountTypeDto(byte value) {
        this.value = value;
    }

    public static AccountTypeDto rawValueOf(byte value) {
        for (AccountTypeDto current : AccountTypeDto.values()) {
            if (value != current.value) continue;
            return current;
        }
        throw new IllegalArgumentException(value + " was not a backing value for AccountTypeDto.");
    }

    @Override
    public int getSize() {
        return 1;
    }

    public byte getValue() {
        return this.value;
    }

    public static AccountTypeDto loadFromBinary(DataInputStream stream) {
        try {
            byte streamValue = stream.readByte();
            return AccountTypeDto.rawValueOf(streamValue);
        }
        catch (Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> dataOutputStream.writeByte(this.value));
    }
}

