/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.catapult.builders;

import io.nem.symbol.catapult.builders.AddressDto;
import io.nem.symbol.catapult.builders.GeneratorUtils;
import io.nem.symbol.catapult.builders.Hash256Dto;
import io.nem.symbol.catapult.builders.HeightDto;
import io.nem.symbol.catapult.builders.LockStatusDto;
import io.nem.symbol.catapult.builders.MosaicBuilder;
import io.nem.symbol.catapult.builders.Serializer;
import java.io.DataInputStream;

public class HashLockInfoBuilder
implements Serializer {
    private final AddressDto ownerAddress;
    private final MosaicBuilder mosaic;
    private final HeightDto endHeight;
    private final LockStatusDto status;
    private final Hash256Dto hash;

    protected HashLockInfoBuilder(DataInputStream stream) {
        try {
            this.ownerAddress = AddressDto.loadFromBinary(stream);
            this.mosaic = MosaicBuilder.loadFromBinary(stream);
            this.endHeight = HeightDto.loadFromBinary(stream);
            this.status = LockStatusDto.loadFromBinary(stream);
            this.hash = Hash256Dto.loadFromBinary(stream);
        }
        catch (Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    public static HashLockInfoBuilder loadFromBinary(DataInputStream stream) {
        return new HashLockInfoBuilder(stream);
    }

    protected HashLockInfoBuilder(AddressDto ownerAddress, MosaicBuilder mosaic, HeightDto endHeight, LockStatusDto status, Hash256Dto hash) {
        GeneratorUtils.notNull(ownerAddress, "ownerAddress is null", new Object[0]);
        GeneratorUtils.notNull(mosaic, "mosaic is null", new Object[0]);
        GeneratorUtils.notNull(endHeight, "endHeight is null", new Object[0]);
        GeneratorUtils.notNull(status, "status is null", new Object[0]);
        GeneratorUtils.notNull(hash, "hash is null", new Object[0]);
        this.ownerAddress = ownerAddress;
        this.mosaic = mosaic;
        this.endHeight = endHeight;
        this.status = status;
        this.hash = hash;
    }

    public static HashLockInfoBuilder create(AddressDto ownerAddress, MosaicBuilder mosaic, HeightDto endHeight, LockStatusDto status, Hash256Dto hash) {
        return new HashLockInfoBuilder(ownerAddress, mosaic, endHeight, status, hash);
    }

    public AddressDto getOwnerAddress() {
        return this.ownerAddress;
    }

    public MosaicBuilder getMosaic() {
        return this.mosaic;
    }

    public HeightDto getEndHeight() {
        return this.endHeight;
    }

    public LockStatusDto getStatus() {
        return this.status;
    }

    public Hash256Dto getHash() {
        return this.hash;
    }

    @Override
    public int getSize() {
        int size = 0;
        size += this.ownerAddress.getSize();
        size += this.mosaic.getSize();
        size += this.endHeight.getSize();
        size += this.status.getSize();
        return size += this.hash.getSize();
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            GeneratorUtils.writeEntity(dataOutputStream, this.ownerAddress);
            GeneratorUtils.writeEntity(dataOutputStream, this.mosaic);
            GeneratorUtils.writeEntity(dataOutputStream, this.endHeight);
            GeneratorUtils.writeEntity(dataOutputStream, this.status);
            GeneratorUtils.writeEntity(dataOutputStream, this.hash);
        });
    }
}

