/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.catapult.builders;

import io.nem.symbol.catapult.builders.AddressDto;
import io.nem.symbol.catapult.builders.GeneratorUtils;
import io.nem.symbol.catapult.builders.MosaicIdDto;
import io.nem.symbol.catapult.builders.NamespaceAliasTypeDto;
import io.nem.symbol.catapult.builders.Serializer;
import java.io.DataInputStream;

public class NamespaceAliasBuilder
implements Serializer {
    private final NamespaceAliasTypeDto namespaceAliasType;
    private MosaicIdDto mosaicAlias;
    private AddressDto addressAlias;

    protected NamespaceAliasBuilder(DataInputStream stream) {
        try {
            this.namespaceAliasType = NamespaceAliasTypeDto.loadFromBinary(stream);
            if (this.namespaceAliasType == NamespaceAliasTypeDto.MOSAIC_ID) {
                this.mosaicAlias = MosaicIdDto.loadFromBinary(stream);
            }
            if (this.namespaceAliasType == NamespaceAliasTypeDto.ADDRESS) {
                this.addressAlias = AddressDto.loadFromBinary(stream);
            }
        }
        catch (Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    public static NamespaceAliasBuilder loadFromBinary(DataInputStream stream) {
        return new NamespaceAliasBuilder(stream);
    }

    protected NamespaceAliasBuilder(NamespaceAliasTypeDto namespaceAliasType, MosaicIdDto mosaicAlias, AddressDto addressAlias) {
        GeneratorUtils.notNull(namespaceAliasType, "namespaceAliasType is null", new Object[0]);
        if (namespaceAliasType == NamespaceAliasTypeDto.MOSAIC_ID) {
            GeneratorUtils.notNull(mosaicAlias, "mosaicAlias is null", new Object[0]);
        }
        if (namespaceAliasType == NamespaceAliasTypeDto.ADDRESS) {
            GeneratorUtils.notNull(addressAlias, "addressAlias is null", new Object[0]);
        }
        this.namespaceAliasType = namespaceAliasType;
        this.mosaicAlias = mosaicAlias;
        this.addressAlias = addressAlias;
    }

    public static NamespaceAliasBuilder createMosaicId(MosaicIdDto mosaicAlias) {
        NamespaceAliasTypeDto namespaceAliasType = NamespaceAliasTypeDto.MOSAIC_ID;
        return new NamespaceAliasBuilder(namespaceAliasType, mosaicAlias, null);
    }

    public static NamespaceAliasBuilder createNone() {
        NamespaceAliasTypeDto namespaceAliasType = NamespaceAliasTypeDto.NONE;
        return new NamespaceAliasBuilder(namespaceAliasType, null, null);
    }

    public static NamespaceAliasBuilder createAddress(AddressDto addressAlias) {
        NamespaceAliasTypeDto namespaceAliasType = NamespaceAliasTypeDto.ADDRESS;
        return new NamespaceAliasBuilder(namespaceAliasType, null, addressAlias);
    }

    public NamespaceAliasTypeDto getNamespaceAliasType() {
        return this.namespaceAliasType;
    }

    public MosaicIdDto getMosaicAlias() {
        if (this.namespaceAliasType != NamespaceAliasTypeDto.MOSAIC_ID) {
            throw new IllegalStateException("namespaceAliasType is not set to MOSAIC_ID.");
        }
        return this.mosaicAlias;
    }

    public AddressDto getAddressAlias() {
        if (this.namespaceAliasType != NamespaceAliasTypeDto.ADDRESS) {
            throw new IllegalStateException("namespaceAliasType is not set to ADDRESS.");
        }
        return this.addressAlias;
    }

    @Override
    public int getSize() {
        int size = 0;
        size += this.namespaceAliasType.getSize();
        if (this.namespaceAliasType == NamespaceAliasTypeDto.MOSAIC_ID) {
            size += this.mosaicAlias.getSize();
        }
        if (this.namespaceAliasType == NamespaceAliasTypeDto.ADDRESS) {
            size += this.addressAlias.getSize();
        }
        return size;
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            GeneratorUtils.writeEntity(dataOutputStream, this.namespaceAliasType);
            if (this.namespaceAliasType == NamespaceAliasTypeDto.MOSAIC_ID) {
                GeneratorUtils.writeEntity(dataOutputStream, this.mosaicAlias);
            }
            if (this.namespaceAliasType == NamespaceAliasTypeDto.ADDRESS) {
                GeneratorUtils.writeEntity(dataOutputStream, this.addressAlias);
            }
        });
    }
}

