/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.catapult.builders;

import io.nem.symbol.catapult.builders.GeneratorUtils;
import io.nem.symbol.catapult.builders.Serializer;
import io.nem.symbol.catapult.builders.UnresolvedAddressDto;
import io.nem.symbol.catapult.builders.UnresolvedMosaicBuilder;
import java.io.DataInputStream;
import java.nio.ByteBuffer;
import java.util.List;

public class TransferTransactionBodyBuilder
implements Serializer {
    private final UnresolvedAddressDto recipientAddress;
    private final int transferTransactionBody_Reserved1;
    private final byte transferTransactionBody_Reserved2;
    private final List<UnresolvedMosaicBuilder> mosaics;
    private final ByteBuffer message;

    protected TransferTransactionBodyBuilder(DataInputStream stream) {
        try {
            this.recipientAddress = UnresolvedAddressDto.loadFromBinary(stream);
            short messageSize = Short.reverseBytes(stream.readShort());
            byte mosaicsCount = stream.readByte();
            this.transferTransactionBody_Reserved1 = Integer.reverseBytes(stream.readInt());
            this.transferTransactionBody_Reserved2 = stream.readByte();
            this.mosaics = GeneratorUtils.loadFromBinaryArray(UnresolvedMosaicBuilder::loadFromBinary, stream, mosaicsCount);
            this.message = GeneratorUtils.readByteBuffer(stream, messageSize);
        }
        catch (Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    public static TransferTransactionBodyBuilder loadFromBinary(DataInputStream stream) {
        return new TransferTransactionBodyBuilder(stream);
    }

    protected TransferTransactionBodyBuilder(UnresolvedAddressDto recipientAddress, List<UnresolvedMosaicBuilder> mosaics, ByteBuffer message) {
        GeneratorUtils.notNull(recipientAddress, "recipientAddress is null", new Object[0]);
        GeneratorUtils.notNull(mosaics, "mosaics is null", new Object[0]);
        GeneratorUtils.notNull(message, "message is null", new Object[0]);
        this.recipientAddress = recipientAddress;
        this.transferTransactionBody_Reserved1 = 0;
        this.transferTransactionBody_Reserved2 = 0;
        this.mosaics = mosaics;
        this.message = message;
    }

    public static TransferTransactionBodyBuilder create(UnresolvedAddressDto recipientAddress, List<UnresolvedMosaicBuilder> mosaics, ByteBuffer message) {
        return new TransferTransactionBodyBuilder(recipientAddress, mosaics, message);
    }

    public UnresolvedAddressDto getRecipientAddress() {
        return this.recipientAddress;
    }

    private int getTransferTransactionBody_Reserved1() {
        return this.transferTransactionBody_Reserved1;
    }

    private byte getTransferTransactionBody_Reserved2() {
        return this.transferTransactionBody_Reserved2;
    }

    public List<UnresolvedMosaicBuilder> getMosaics() {
        return this.mosaics;
    }

    public ByteBuffer getMessage() {
        return this.message;
    }

    @Override
    public int getSize() {
        int size = 0;
        size += this.recipientAddress.getSize();
        size += 2;
        ++size;
        size += 4;
        ++size;
        size += this.mosaics.stream().mapToInt(o -> o.getSize()).sum();
        return size += this.message.array().length;
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            GeneratorUtils.writeEntity(dataOutputStream, this.recipientAddress);
            dataOutputStream.writeShort(Short.reverseBytes((short)GeneratorUtils.getSize(this.getMessage())));
            dataOutputStream.writeByte((byte)GeneratorUtils.getSize(this.getMosaics()));
            dataOutputStream.writeInt(Integer.reverseBytes(this.getTransferTransactionBody_Reserved1()));
            dataOutputStream.writeByte(this.getTransferTransactionBody_Reserved2());
            GeneratorUtils.writeList(dataOutputStream, this.mosaics);
            dataOutputStream.write(this.message.array(), 0, this.message.array().length);
        });
    }
}

