/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.catapult.builders;

import io.nem.symbol.catapult.builders.GeneratorUtils;
import io.nem.symbol.catapult.builders.Serializer;
import java.io.DataInputStream;

public final class AmountDto
implements Serializer {
    private final long amount;

    public AmountDto(long amount) {
        this.amount = amount;
        GeneratorUtils.writeBuilderToFile(this, System.getProperty("user.home") + "/catbuffers.yml");
    }

    public AmountDto(DataInputStream stream) {
        try {
            this.amount = Long.reverseBytes(stream.readLong());
        }
        catch (Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
        GeneratorUtils.writeBuilderToFile(this, System.getProperty("user.home") + "/catbuffers.yml");
    }

    public long getAmount() {
        return this.amount;
    }

    @Override
    public int getSize() {
        return 8;
    }

    public static AmountDto loadFromBinary(DataInputStream stream) {
        return new AmountDto(stream);
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> dataOutputStream.writeLong(Long.reverseBytes(this.getAmount())));
    }
}

