/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.catapult.builders;

import io.nem.symbol.catapult.builders.GeneratorUtils;
import io.nem.symbol.catapult.builders.KeyDto;
import io.nem.symbol.catapult.builders.Serializer;
import io.nem.symbol.catapult.builders.SignatureDto;
import java.io.DataInputStream;

public class CosignatureBuilder
implements Serializer {
    private final long version;
    private final KeyDto signerPublicKey;
    private final SignatureDto signature;

    protected CosignatureBuilder(DataInputStream stream) {
        try {
            this.version = Long.reverseBytes(stream.readLong());
            this.signerPublicKey = KeyDto.loadFromBinary(stream);
            this.signature = SignatureDto.loadFromBinary(stream);
        }
        catch (Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    public static CosignatureBuilder loadFromBinary(DataInputStream stream) {
        return new CosignatureBuilder(stream);
    }

    protected CosignatureBuilder(long version, KeyDto signerPublicKey, SignatureDto signature) {
        GeneratorUtils.notNull(version, "version is null", new Object[0]);
        GeneratorUtils.notNull(signerPublicKey, "signerPublicKey is null", new Object[0]);
        GeneratorUtils.notNull(signature, "signature is null", new Object[0]);
        this.version = version;
        this.signerPublicKey = signerPublicKey;
        this.signature = signature;
    }

    public static CosignatureBuilder create(long version, KeyDto signerPublicKey, SignatureDto signature) {
        return new CosignatureBuilder(version, signerPublicKey, signature);
    }

    public long getVersion() {
        return this.version;
    }

    public KeyDto getSignerPublicKey() {
        return this.signerPublicKey;
    }

    public SignatureDto getSignature() {
        return this.signature;
    }

    @Override
    public int getSize() {
        int size = 0;
        size += 8;
        size += this.signerPublicKey.getSize();
        return size += this.signature.getSize();
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            dataOutputStream.writeLong(Long.reverseBytes(this.getVersion()));
            GeneratorUtils.writeEntity(dataOutputStream, this.signerPublicKey);
            GeneratorUtils.writeEntity(dataOutputStream, this.signature);
        });
    }
}

