/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.catapult.builders;

import io.nem.symbol.catapult.builders.GeneratorUtils;
import io.nem.symbol.catapult.builders.Serializer;
import java.io.DataInputStream;

public final class DifficultyDto
implements Serializer {
    private final long difficulty;

    public DifficultyDto(long difficulty) {
        this.difficulty = difficulty;
        GeneratorUtils.writeBuilderToFile(this, System.getProperty("user.home") + "/catbuffers.yml");
    }

    public DifficultyDto(DataInputStream stream) {
        try {
            this.difficulty = Long.reverseBytes(stream.readLong());
        }
        catch (Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
        GeneratorUtils.writeBuilderToFile(this, System.getProperty("user.home") + "/catbuffers.yml");
    }

    public long getDifficulty() {
        return this.difficulty;
    }

    @Override
    public int getSize() {
        return 8;
    }

    public static DifficultyDto loadFromBinary(DataInputStream stream) {
        return new DifficultyDto(stream);
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> dataOutputStream.writeLong(Long.reverseBytes(this.getDifficulty())));
    }
}

