/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.catapult.builders;

import io.nem.symbol.catapult.builders.FinalizationRoundBuilder;
import io.nem.symbol.catapult.builders.GeneratorUtils;
import io.nem.symbol.catapult.builders.Hash256Dto;
import io.nem.symbol.catapult.builders.HeightDto;
import io.nem.symbol.catapult.builders.Serializer;
import java.io.DataInputStream;

public class FinalizedBlockHeaderBuilder
implements Serializer {
    private final FinalizationRoundBuilder round;
    private final HeightDto height;
    private final Hash256Dto hash;

    protected FinalizedBlockHeaderBuilder(DataInputStream stream) {
        try {
            this.round = FinalizationRoundBuilder.loadFromBinary(stream);
            this.height = HeightDto.loadFromBinary(stream);
            this.hash = Hash256Dto.loadFromBinary(stream);
        }
        catch (Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    public static FinalizedBlockHeaderBuilder loadFromBinary(DataInputStream stream) {
        return new FinalizedBlockHeaderBuilder(stream);
    }

    protected FinalizedBlockHeaderBuilder(FinalizationRoundBuilder round, HeightDto height, Hash256Dto hash) {
        GeneratorUtils.notNull(round, "round is null", new Object[0]);
        GeneratorUtils.notNull(height, "height is null", new Object[0]);
        GeneratorUtils.notNull(hash, "hash is null", new Object[0]);
        this.round = round;
        this.height = height;
        this.hash = hash;
    }

    public static FinalizedBlockHeaderBuilder create(FinalizationRoundBuilder round, HeightDto height, Hash256Dto hash) {
        return new FinalizedBlockHeaderBuilder(round, height, hash);
    }

    public FinalizationRoundBuilder getRound() {
        return this.round;
    }

    public HeightDto getHeight() {
        return this.height;
    }

    public Hash256Dto getHash() {
        return this.hash;
    }

    @Override
    public int getSize() {
        int size = 0;
        size += this.round.getSize();
        size += this.height.getSize();
        return size += this.hash.getSize();
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            GeneratorUtils.writeEntity(dataOutputStream, this.round);
            GeneratorUtils.writeEntity(dataOutputStream, this.height);
            GeneratorUtils.writeEntity(dataOutputStream, this.hash);
        });
    }
}

