/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.catapult.builders;

import io.nem.symbol.catapult.builders.GeneratorUtils;
import io.nem.symbol.catapult.builders.Serializer;
import java.io.DataInputStream;
import java.nio.ByteBuffer;

public final class KeyDto
implements Serializer {
    private final ByteBuffer key;

    public KeyDto(ByteBuffer key) {
        this.key = key;
        GeneratorUtils.writeBuilderToFile(this, System.getProperty("user.home") + "/catbuffers.yml");
    }

    public KeyDto(DataInputStream stream) {
        try {
            this.key = GeneratorUtils.readByteBuffer(stream, 32);
        }
        catch (Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
        GeneratorUtils.writeBuilderToFile(this, System.getProperty("user.home") + "/catbuffers.yml");
    }

    public ByteBuffer getKey() {
        return this.key;
    }

    @Override
    public int getSize() {
        return 32;
    }

    public static KeyDto loadFromBinary(DataInputStream stream) {
        return new KeyDto(stream);
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> dataOutputStream.write(this.key.array(), 0, this.key.array().length));
    }
}

