/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.catapult.builders;

import io.nem.symbol.catapult.builders.AddressDto;
import io.nem.symbol.catapult.builders.AddressKeyValueSetBuilder;
import io.nem.symbol.catapult.builders.GeneratorUtils;
import io.nem.symbol.catapult.builders.MosaicIdDto;
import io.nem.symbol.catapult.builders.Serializer;
import java.io.DataInputStream;

public class MosaicAddressRestrictionEntryBuilder
implements Serializer {
    private final MosaicIdDto mosaicId;
    private final AddressDto address;
    private final AddressKeyValueSetBuilder keyPairs;

    protected MosaicAddressRestrictionEntryBuilder(DataInputStream stream) {
        try {
            this.mosaicId = MosaicIdDto.loadFromBinary(stream);
            this.address = AddressDto.loadFromBinary(stream);
            this.keyPairs = AddressKeyValueSetBuilder.loadFromBinary(stream);
        }
        catch (Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    public static MosaicAddressRestrictionEntryBuilder loadFromBinary(DataInputStream stream) {
        return new MosaicAddressRestrictionEntryBuilder(stream);
    }

    protected MosaicAddressRestrictionEntryBuilder(MosaicIdDto mosaicId, AddressDto address, AddressKeyValueSetBuilder keyPairs) {
        GeneratorUtils.notNull(mosaicId, "mosaicId is null", new Object[0]);
        GeneratorUtils.notNull(address, "address is null", new Object[0]);
        GeneratorUtils.notNull(keyPairs, "keyPairs is null", new Object[0]);
        this.mosaicId = mosaicId;
        this.address = address;
        this.keyPairs = keyPairs;
    }

    public static MosaicAddressRestrictionEntryBuilder create(MosaicIdDto mosaicId, AddressDto address, AddressKeyValueSetBuilder keyPairs) {
        return new MosaicAddressRestrictionEntryBuilder(mosaicId, address, keyPairs);
    }

    public MosaicIdDto getMosaicId() {
        return this.mosaicId;
    }

    public AddressDto getAddress() {
        return this.address;
    }

    public AddressKeyValueSetBuilder getKeyPairs() {
        return this.keyPairs;
    }

    @Override
    public int getSize() {
        int size = 0;
        size += this.mosaicId.getSize();
        size += this.address.getSize();
        return size += this.keyPairs.getSize();
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            GeneratorUtils.writeEntity(dataOutputStream, this.mosaicId);
            GeneratorUtils.writeEntity(dataOutputStream, this.address);
            GeneratorUtils.writeEntity(dataOutputStream, this.keyPairs);
        });
    }
}

