/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.catapult.builders;

import io.nem.symbol.catapult.builders.GeneratorUtils;
import io.nem.symbol.catapult.builders.Serializer;
import java.io.DataInputStream;

public final class MosaicNonceDto
implements Serializer {
    private final int mosaicNonce;

    public MosaicNonceDto(int mosaicNonce) {
        this.mosaicNonce = mosaicNonce;
        GeneratorUtils.writeBuilderToFile(this, System.getProperty("user.home") + "/catbuffers.yml");
    }

    public MosaicNonceDto(DataInputStream stream) {
        try {
            this.mosaicNonce = Integer.reverseBytes(stream.readInt());
        }
        catch (Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
        GeneratorUtils.writeBuilderToFile(this, System.getProperty("user.home") + "/catbuffers.yml");
    }

    public int getMosaicNonce() {
        return this.mosaicNonce;
    }

    @Override
    public int getSize() {
        return 4;
    }

    public static MosaicNonceDto loadFromBinary(DataInputStream stream) {
        return new MosaicNonceDto(stream);
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> dataOutputStream.writeInt(Integer.reverseBytes(this.getMosaicNonce())));
    }
}

