/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.catapult.builders;

import io.nem.symbol.catapult.builders.GeneratorUtils;
import io.nem.symbol.catapult.builders.Serializer;
import java.io.DataInputStream;

public enum NetworkTypeDto implements Serializer
{
    MIJIN(96),
    PUBLIC(104),
    PRIVATE(120),
    MIJIN_TEST(-112),
    PUBLIC_TEST(-104),
    PRIVATE_TEST(-88);

    private final byte value;

    private NetworkTypeDto(byte value) {
        this.value = value;
    }

    public static NetworkTypeDto rawValueOf(byte value) {
        for (NetworkTypeDto current : NetworkTypeDto.values()) {
            if (value != current.value) continue;
            return current;
        }
        throw new IllegalArgumentException(value + " was not a backing value for NetworkTypeDto.");
    }

    @Override
    public int getSize() {
        return 1;
    }

    public byte getValue() {
        return this.value;
    }

    public static NetworkTypeDto loadFromBinary(DataInputStream stream) {
        try {
            byte streamValue = stream.readByte();
            return NetworkTypeDto.rawValueOf(streamValue);
        }
        catch (Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> dataOutputStream.writeByte(this.value));
    }
}

