/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.catapult.builders;

import io.nem.symbol.catapult.builders.GeneratorUtils;
import io.nem.symbol.catapult.builders.Hash256Dto;
import io.nem.symbol.catapult.builders.LockHashAlgorithmDto;
import io.nem.symbol.catapult.builders.Serializer;
import io.nem.symbol.catapult.builders.UnresolvedAddressDto;
import java.io.DataInputStream;
import java.nio.ByteBuffer;

public class SecretProofTransactionBodyBuilder
implements Serializer {
    private final UnresolvedAddressDto recipientAddress;
    private final Hash256Dto secret;
    private final LockHashAlgorithmDto hashAlgorithm;
    private final ByteBuffer proof;

    protected SecretProofTransactionBodyBuilder(DataInputStream stream) {
        try {
            this.recipientAddress = UnresolvedAddressDto.loadFromBinary(stream);
            this.secret = Hash256Dto.loadFromBinary(stream);
            short proofSize = Short.reverseBytes(stream.readShort());
            this.hashAlgorithm = LockHashAlgorithmDto.loadFromBinary(stream);
            this.proof = GeneratorUtils.readByteBuffer(stream, proofSize);
        }
        catch (Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    public static SecretProofTransactionBodyBuilder loadFromBinary(DataInputStream stream) {
        return new SecretProofTransactionBodyBuilder(stream);
    }

    protected SecretProofTransactionBodyBuilder(UnresolvedAddressDto recipientAddress, Hash256Dto secret, LockHashAlgorithmDto hashAlgorithm, ByteBuffer proof) {
        GeneratorUtils.notNull(recipientAddress, "recipientAddress is null", new Object[0]);
        GeneratorUtils.notNull(secret, "secret is null", new Object[0]);
        GeneratorUtils.notNull(hashAlgorithm, "hashAlgorithm is null", new Object[0]);
        GeneratorUtils.notNull(proof, "proof is null", new Object[0]);
        this.recipientAddress = recipientAddress;
        this.secret = secret;
        this.hashAlgorithm = hashAlgorithm;
        this.proof = proof;
    }

    public static SecretProofTransactionBodyBuilder create(UnresolvedAddressDto recipientAddress, Hash256Dto secret, LockHashAlgorithmDto hashAlgorithm, ByteBuffer proof) {
        return new SecretProofTransactionBodyBuilder(recipientAddress, secret, hashAlgorithm, proof);
    }

    public UnresolvedAddressDto getRecipientAddress() {
        return this.recipientAddress;
    }

    public Hash256Dto getSecret() {
        return this.secret;
    }

    public LockHashAlgorithmDto getHashAlgorithm() {
        return this.hashAlgorithm;
    }

    public ByteBuffer getProof() {
        return this.proof;
    }

    @Override
    public int getSize() {
        int size = 0;
        size += this.recipientAddress.getSize();
        size += this.secret.getSize();
        size += 2;
        size += this.hashAlgorithm.getSize();
        return size += this.proof.array().length;
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            GeneratorUtils.writeEntity(dataOutputStream, this.recipientAddress);
            GeneratorUtils.writeEntity(dataOutputStream, this.secret);
            dataOutputStream.writeShort(Short.reverseBytes((short)GeneratorUtils.getSize(this.getProof())));
            GeneratorUtils.writeEntity(dataOutputStream, this.hashAlgorithm);
            dataOutputStream.write(this.proof.array(), 0, this.proof.array().length);
        });
    }
}

