/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.catapult.builders;

import io.nem.symbol.catapult.builders.GeneratorUtils;
import io.nem.symbol.catapult.builders.Serializer;
import java.io.DataInputStream;

public final class HeightDto
implements Serializer {
    private final long height;

    public HeightDto(long height) {
        this.height = height;
    }

    public HeightDto(DataInputStream stream) {
        try {
            this.height = Long.reverseBytes(stream.readLong());
        }
        catch (Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    public long getHeight() {
        return this.height;
    }

    @Override
    public int getSize() {
        return 8;
    }

    public static HeightDto loadFromBinary(DataInputStream stream) {
        return new HeightDto(stream);
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> dataOutputStream.writeLong(Long.reverseBytes(this.getHeight())));
    }
}

