/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.catapult.builders;

import io.nem.symbol.catapult.builders.GeneratorUtils;
import io.nem.symbol.catapult.builders.ImportanceDto;
import io.nem.symbol.catapult.builders.ImportanceHeightDto;
import io.nem.symbol.catapult.builders.Serializer;
import java.io.DataInputStream;

public class ImportanceSnapshotBuilder
implements Serializer {
    private final ImportanceDto importance;
    private final ImportanceHeightDto height;

    protected ImportanceSnapshotBuilder(DataInputStream stream) {
        try {
            this.importance = ImportanceDto.loadFromBinary(stream);
            this.height = ImportanceHeightDto.loadFromBinary(stream);
        }
        catch (Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    public static ImportanceSnapshotBuilder loadFromBinary(DataInputStream stream) {
        return new ImportanceSnapshotBuilder(stream);
    }

    protected ImportanceSnapshotBuilder(ImportanceDto importance, ImportanceHeightDto height) {
        GeneratorUtils.notNull(importance, "importance is null", new Object[0]);
        GeneratorUtils.notNull(height, "height is null", new Object[0]);
        this.importance = importance;
        this.height = height;
    }

    public static ImportanceSnapshotBuilder create(ImportanceDto importance, ImportanceHeightDto height) {
        return new ImportanceSnapshotBuilder(importance, height);
    }

    public ImportanceDto getImportance() {
        return this.importance;
    }

    public ImportanceHeightDto getHeight() {
        return this.height;
    }

    @Override
    public int getSize() {
        int size = 0;
        size += this.importance.getSize();
        return size += this.height.getSize();
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            GeneratorUtils.writeEntity(dataOutputStream, this.importance);
            GeneratorUtils.writeEntity(dataOutputStream, this.height);
        });
    }
}

