/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.catapult.builders;

import io.nem.symbol.catapult.builders.GeneratorUtils;
import io.nem.symbol.catapult.builders.Serializer;
import java.io.DataInputStream;
import java.nio.ByteBuffer;

public class MetadataValueBuilder
implements Serializer {
    private final ByteBuffer data;

    protected MetadataValueBuilder(DataInputStream stream) {
        try {
            short size = Short.reverseBytes(stream.readShort());
            this.data = GeneratorUtils.readByteBuffer(stream, size);
        }
        catch (Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    public static MetadataValueBuilder loadFromBinary(DataInputStream stream) {
        return new MetadataValueBuilder(stream);
    }

    protected MetadataValueBuilder(ByteBuffer data) {
        GeneratorUtils.notNull(data, "data is null", new Object[0]);
        this.data = data;
    }

    public static MetadataValueBuilder create(ByteBuffer data) {
        return new MetadataValueBuilder(data);
    }

    public ByteBuffer getData() {
        return this.data;
    }

    @Override
    public int getSize() {
        int size = 0;
        size += 2;
        return size += this.data.array().length;
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            dataOutputStream.writeShort(Short.reverseBytes((short)GeneratorUtils.getSize(this.getData())));
            dataOutputStream.write(this.data.array(), 0, this.data.array().length);
        });
    }
}

