/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.catapult.builders;

import io.nem.symbol.catapult.builders.BitMaskable;
import io.nem.symbol.catapult.builders.GeneratorUtils;
import io.nem.symbol.catapult.builders.Serializer;
import java.io.DataInputStream;

public enum MosaicFlagsDto implements BitMaskable,
Serializer
{
    NONE(0),
    SUPPLY_MUTABLE(1),
    TRANSFERABLE(2),
    RESTRICTABLE(4),
    REVOKABLE(8);

    private final byte value;

    private MosaicFlagsDto(byte value) {
        this.value = value;
    }

    public static MosaicFlagsDto rawValueOf(byte value) {
        for (MosaicFlagsDto current : MosaicFlagsDto.values()) {
            if (value != current.value) continue;
            return current;
        }
        throw new IllegalArgumentException(value + " was not a backing value for MosaicFlagsDto.");
    }

    @Override
    public int getSize() {
        return 1;
    }

    public byte getValue() {
        return this.value;
    }

    @Override
    public long getValueAsLong() {
        return GeneratorUtils.toUnsignedInt(this.value);
    }

    public static MosaicFlagsDto loadFromBinary(DataInputStream stream) {
        try {
            byte streamValue = stream.readByte();
            return MosaicFlagsDto.rawValueOf(streamValue);
        }
        catch (Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> dataOutputStream.writeByte(this.value));
    }
}

