/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.catapult.builders;

import io.nem.symbol.catapult.builders.AmountDto;
import io.nem.symbol.catapult.builders.BlockDurationDto;
import io.nem.symbol.catapult.builders.EntityTypeDto;
import io.nem.symbol.catapult.builders.GeneratorUtils;
import io.nem.symbol.catapult.builders.KeyDto;
import io.nem.symbol.catapult.builders.NamespaceIdDto;
import io.nem.symbol.catapult.builders.NamespaceRegistrationTransactionBodyBuilder;
import io.nem.symbol.catapult.builders.NamespaceRegistrationTypeDto;
import io.nem.symbol.catapult.builders.NetworkTypeDto;
import io.nem.symbol.catapult.builders.Serializer;
import io.nem.symbol.catapult.builders.SignatureDto;
import io.nem.symbol.catapult.builders.TimestampDto;
import io.nem.symbol.catapult.builders.TransactionBuilder;
import java.io.DataInputStream;
import java.nio.ByteBuffer;

public class NamespaceRegistrationTransactionBuilder
extends TransactionBuilder
implements Serializer {
    private final NamespaceRegistrationTransactionBodyBuilder namespaceRegistrationTransactionBody;

    protected NamespaceRegistrationTransactionBuilder(DataInputStream stream) {
        super(stream);
        try {
            this.namespaceRegistrationTransactionBody = NamespaceRegistrationTransactionBodyBuilder.loadFromBinary(stream);
        }
        catch (Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    public static NamespaceRegistrationTransactionBuilder loadFromBinary(DataInputStream stream) {
        return new NamespaceRegistrationTransactionBuilder(stream);
    }

    protected NamespaceRegistrationTransactionBuilder(SignatureDto signature, KeyDto signerPublicKey, byte version, NetworkTypeDto network, EntityTypeDto type, AmountDto fee, TimestampDto deadline, BlockDurationDto duration, NamespaceIdDto parentId, NamespaceIdDto id, NamespaceRegistrationTypeDto registrationType, ByteBuffer name) {
        super(signature, signerPublicKey, version, network, type, fee, deadline);
        GeneratorUtils.notNull(signature, "signature is null", new Object[0]);
        GeneratorUtils.notNull(signerPublicKey, "signerPublicKey is null", new Object[0]);
        GeneratorUtils.notNull(version, "version is null", new Object[0]);
        GeneratorUtils.notNull(network, "network is null", new Object[0]);
        GeneratorUtils.notNull(type, "type is null", new Object[0]);
        GeneratorUtils.notNull(fee, "fee is null", new Object[0]);
        GeneratorUtils.notNull(deadline, "deadline is null", new Object[0]);
        if (registrationType == NamespaceRegistrationTypeDto.ROOT) {
            GeneratorUtils.notNull(duration, "duration is null", new Object[0]);
        }
        if (registrationType == NamespaceRegistrationTypeDto.CHILD) {
            GeneratorUtils.notNull(parentId, "parentId is null", new Object[0]);
        }
        GeneratorUtils.notNull(id, "id is null", new Object[0]);
        GeneratorUtils.notNull(registrationType, "registrationType is null", new Object[0]);
        GeneratorUtils.notNull(name, "name is null", new Object[0]);
        this.namespaceRegistrationTransactionBody = new NamespaceRegistrationTransactionBodyBuilder(duration, parentId, id, registrationType, name);
    }

    public static NamespaceRegistrationTransactionBuilder createRoot(SignatureDto signature, KeyDto signerPublicKey, byte version, NetworkTypeDto network, EntityTypeDto type, AmountDto fee, TimestampDto deadline, BlockDurationDto duration, NamespaceIdDto id, ByteBuffer name) {
        NamespaceRegistrationTypeDto registrationType = NamespaceRegistrationTypeDto.ROOT;
        return new NamespaceRegistrationTransactionBuilder(signature, signerPublicKey, version, network, type, fee, deadline, duration, null, id, registrationType, name);
    }

    public static NamespaceRegistrationTransactionBuilder createChild(SignatureDto signature, KeyDto signerPublicKey, byte version, NetworkTypeDto network, EntityTypeDto type, AmountDto fee, TimestampDto deadline, NamespaceIdDto parentId, NamespaceIdDto id, ByteBuffer name) {
        NamespaceRegistrationTypeDto registrationType = NamespaceRegistrationTypeDto.CHILD;
        return new NamespaceRegistrationTransactionBuilder(signature, signerPublicKey, version, network, type, fee, deadline, null, parentId, id, registrationType, name);
    }

    public BlockDurationDto getDuration() {
        return this.namespaceRegistrationTransactionBody.getDuration();
    }

    public NamespaceIdDto getParentId() {
        return this.namespaceRegistrationTransactionBody.getParentId();
    }

    public NamespaceIdDto getId() {
        return this.namespaceRegistrationTransactionBody.getId();
    }

    public NamespaceRegistrationTypeDto getRegistrationType() {
        return this.namespaceRegistrationTransactionBody.getRegistrationType();
    }

    public ByteBuffer getName() {
        return this.namespaceRegistrationTransactionBody.getName();
    }

    @Override
    public int getSize() {
        int size = super.getSize();
        return size += this.namespaceRegistrationTransactionBody.getSize();
    }

    @Override
    public NamespaceRegistrationTransactionBodyBuilder getBody() {
        return this.namespaceRegistrationTransactionBody;
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            byte[] superBytes = super.serialize();
            dataOutputStream.write(superBytes, 0, superBytes.length);
            GeneratorUtils.writeEntity(dataOutputStream, this.namespaceRegistrationTransactionBody);
        });
    }
}

