/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.catapult.builders;

import io.nem.symbol.catapult.builders.BitMaskable;
import io.nem.symbol.catapult.builders.GeneratorUtils;
import io.nem.symbol.catapult.builders.Serializer;
import java.io.DataInputStream;

public enum AccountKeyTypeFlagsDto implements BitMaskable,
Serializer
{
    UNSET(0),
    LINKED(1),
    NODE(2),
    VRF(4);

    private final byte value;

    private AccountKeyTypeFlagsDto(byte value) {
        this.value = value;
    }

    public static AccountKeyTypeFlagsDto rawValueOf(byte value) {
        for (AccountKeyTypeFlagsDto current : AccountKeyTypeFlagsDto.values()) {
            if (value != current.value) continue;
            return current;
        }
        throw new IllegalArgumentException(value + " was not a backing value for AccountKeyTypeFlagsDto.");
    }

    @Override
    public int getSize() {
        return 1;
    }

    public byte getValue() {
        return this.value;
    }

    @Override
    public long getValueAsLong() {
        return GeneratorUtils.toUnsignedInt(this.value);
    }

    public static AccountKeyTypeFlagsDto loadFromBinary(DataInputStream stream) {
        try {
            byte streamValue = stream.readByte();
            return AccountKeyTypeFlagsDto.rawValueOf(streamValue);
        }
        catch (Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> dataOutputStream.writeByte(this.value));
    }
}

