/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.catapult.builders;

import io.nem.symbol.catapult.builders.GeneratorUtils;
import io.nem.symbol.catapult.builders.MosaicIdDto;
import io.nem.symbol.catapult.builders.Serializer;
import java.io.DataInputStream;
import java.util.List;

public class AccountRestrictionMosaicValueBuilder
implements Serializer {
    private final List<MosaicIdDto> restrictionValues;

    protected AccountRestrictionMosaicValueBuilder(DataInputStream stream) {
        try {
            long restrictionValuesCount = Long.reverseBytes(stream.readLong());
            this.restrictionValues = GeneratorUtils.loadFromBinaryArray(MosaicIdDto::loadFromBinary, stream, restrictionValuesCount, 0);
        }
        catch (Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    public static AccountRestrictionMosaicValueBuilder loadFromBinary(DataInputStream stream) {
        return new AccountRestrictionMosaicValueBuilder(stream);
    }

    protected AccountRestrictionMosaicValueBuilder(List<MosaicIdDto> restrictionValues) {
        GeneratorUtils.notNull(restrictionValues, "restrictionValues is null", new Object[0]);
        this.restrictionValues = restrictionValues;
    }

    public static AccountRestrictionMosaicValueBuilder create(List<MosaicIdDto> restrictionValues) {
        return new AccountRestrictionMosaicValueBuilder(restrictionValues);
    }

    public List<MosaicIdDto> getRestrictionValues() {
        return this.restrictionValues;
    }

    @Override
    public int getSize() {
        int size = 0;
        size += 8;
        return size += GeneratorUtils.getSumSize(this.restrictionValues, 0);
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            dataOutputStream.writeLong(Long.reverseBytes(GeneratorUtils.getSize(this.getRestrictionValues())));
            GeneratorUtils.writeList(dataOutputStream, this.restrictionValues, 0);
        });
    }
}

