/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.catapult.builders;

import io.nem.symbol.catapult.builders.AggregateTransactionBodyBuilder;
import io.nem.symbol.catapult.builders.AmountDto;
import io.nem.symbol.catapult.builders.CosignatureBuilder;
import io.nem.symbol.catapult.builders.EmbeddedTransactionBuilder;
import io.nem.symbol.catapult.builders.GeneratorUtils;
import io.nem.symbol.catapult.builders.Hash256Dto;
import io.nem.symbol.catapult.builders.NetworkTypeDto;
import io.nem.symbol.catapult.builders.PublicKeyDto;
import io.nem.symbol.catapult.builders.Serializer;
import io.nem.symbol.catapult.builders.SignatureDto;
import io.nem.symbol.catapult.builders.TimestampDto;
import io.nem.symbol.catapult.builders.TransactionBuilder;
import io.nem.symbol.catapult.builders.TransactionTypeDto;
import java.io.DataInputStream;
import java.util.List;

public class AggregateBondedTransactionBuilder
extends TransactionBuilder
implements Serializer {
    private final AggregateTransactionBodyBuilder aggregateTransactionBody;

    protected AggregateBondedTransactionBuilder(DataInputStream stream) {
        super(stream);
        try {
            this.aggregateTransactionBody = AggregateTransactionBodyBuilder.loadFromBinary(stream);
        }
        catch (Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    public static AggregateBondedTransactionBuilder loadFromBinary(DataInputStream stream) {
        return new AggregateBondedTransactionBuilder(stream);
    }

    protected AggregateBondedTransactionBuilder(SignatureDto signature, PublicKeyDto signerPublicKey, byte version, NetworkTypeDto network, TransactionTypeDto type, AmountDto fee, TimestampDto deadline, Hash256Dto transactionsHash, List<EmbeddedTransactionBuilder> transactions, List<CosignatureBuilder> cosignatures) {
        super(signature, signerPublicKey, version, network, type, fee, deadline);
        GeneratorUtils.notNull(signature, "signature is null", new Object[0]);
        GeneratorUtils.notNull(signerPublicKey, "signerPublicKey is null", new Object[0]);
        GeneratorUtils.notNull(version, "version is null", new Object[0]);
        GeneratorUtils.notNull(network, "network is null", new Object[0]);
        GeneratorUtils.notNull(type, "type is null", new Object[0]);
        GeneratorUtils.notNull(fee, "fee is null", new Object[0]);
        GeneratorUtils.notNull(deadline, "deadline is null", new Object[0]);
        GeneratorUtils.notNull(transactionsHash, "transactionsHash is null", new Object[0]);
        GeneratorUtils.notNull(transactions, "transactions is null", new Object[0]);
        GeneratorUtils.notNull(cosignatures, "cosignatures is null", new Object[0]);
        this.aggregateTransactionBody = new AggregateTransactionBodyBuilder(transactionsHash, transactions, cosignatures);
    }

    public static AggregateBondedTransactionBuilder create(SignatureDto signature, PublicKeyDto signerPublicKey, byte version, NetworkTypeDto network, TransactionTypeDto type, AmountDto fee, TimestampDto deadline, Hash256Dto transactionsHash, List<EmbeddedTransactionBuilder> transactions, List<CosignatureBuilder> cosignatures) {
        return new AggregateBondedTransactionBuilder(signature, signerPublicKey, version, network, type, fee, deadline, transactionsHash, transactions, cosignatures);
    }

    public Hash256Dto getTransactionsHash() {
        return this.aggregateTransactionBody.getTransactionsHash();
    }

    public List<EmbeddedTransactionBuilder> getTransactions() {
        return this.aggregateTransactionBody.getTransactions();
    }

    public List<CosignatureBuilder> getCosignatures() {
        return this.aggregateTransactionBody.getCosignatures();
    }

    @Override
    public int getSize() {
        int size = super.getSize();
        return size += this.aggregateTransactionBody.getSize();
    }

    @Override
    public AggregateTransactionBodyBuilder getBody() {
        return this.aggregateTransactionBody;
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            byte[] superBytes = super.serialize();
            dataOutputStream.write(superBytes, 0, superBytes.length);
            GeneratorUtils.writeEntity(dataOutputStream, this.aggregateTransactionBody);
        });
    }
}

