/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.catapult.builders;

import io.nem.symbol.catapult.builders.CosignatureBuilder;
import io.nem.symbol.catapult.builders.EmbeddedTransactionBuilder;
import io.nem.symbol.catapult.builders.EmbeddedTransactionBuilderHelper;
import io.nem.symbol.catapult.builders.GeneratorUtils;
import io.nem.symbol.catapult.builders.Hash256Dto;
import io.nem.symbol.catapult.builders.Serializer;
import java.io.DataInputStream;
import java.util.List;

public class AggregateTransactionBodyBuilder
implements Serializer {
    private final Hash256Dto transactionsHash;
    private final int aggregateTransactionHeaderReserved1;
    private final List<EmbeddedTransactionBuilder> transactions;
    private final List<CosignatureBuilder> cosignatures;

    protected AggregateTransactionBodyBuilder(DataInputStream stream) {
        try {
            this.transactionsHash = Hash256Dto.loadFromBinary(stream);
            int payloadSize = Integer.reverseBytes(stream.readInt());
            this.aggregateTransactionHeaderReserved1 = Integer.reverseBytes(stream.readInt());
            this.transactions = GeneratorUtils.loadFromBinaryArrayRemaining(EmbeddedTransactionBuilderHelper::loadFromBinary, stream, payloadSize, 8);
            this.cosignatures = GeneratorUtils.loadFromBinaryArrayRemaining(CosignatureBuilder::loadFromBinary, stream, 0);
        }
        catch (Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    public static AggregateTransactionBodyBuilder loadFromBinary(DataInputStream stream) {
        return new AggregateTransactionBodyBuilder(stream);
    }

    protected AggregateTransactionBodyBuilder(Hash256Dto transactionsHash, List<EmbeddedTransactionBuilder> transactions, List<CosignatureBuilder> cosignatures) {
        GeneratorUtils.notNull(transactionsHash, "transactionsHash is null", new Object[0]);
        GeneratorUtils.notNull(transactions, "transactions is null", new Object[0]);
        GeneratorUtils.notNull(cosignatures, "cosignatures is null", new Object[0]);
        this.transactionsHash = transactionsHash;
        this.aggregateTransactionHeaderReserved1 = 0;
        this.transactions = transactions;
        this.cosignatures = cosignatures;
    }

    public static AggregateTransactionBodyBuilder create(Hash256Dto transactionsHash, List<EmbeddedTransactionBuilder> transactions, List<CosignatureBuilder> cosignatures) {
        return new AggregateTransactionBodyBuilder(transactionsHash, transactions, cosignatures);
    }

    public Hash256Dto getTransactionsHash() {
        return this.transactionsHash;
    }

    private int getAggregateTransactionHeaderReserved1() {
        return this.aggregateTransactionHeaderReserved1;
    }

    public List<EmbeddedTransactionBuilder> getTransactions() {
        return this.transactions;
    }

    public List<CosignatureBuilder> getCosignatures() {
        return this.cosignatures;
    }

    @Override
    public int getSize() {
        int size = 0;
        size += this.transactionsHash.getSize();
        size += 4;
        size += 4;
        size += GeneratorUtils.getSumSize(this.transactions, 8);
        return size += GeneratorUtils.getSumSize(this.cosignatures, 0);
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            GeneratorUtils.writeEntity(dataOutputStream, this.transactionsHash);
            dataOutputStream.writeInt(Integer.reverseBytes(GeneratorUtils.getSumSize(this.getTransactions(), 8)));
            dataOutputStream.writeInt(Integer.reverseBytes(this.getAggregateTransactionHeaderReserved1()));
            GeneratorUtils.writeList(dataOutputStream, this.transactions, 8);
            GeneratorUtils.writeList(dataOutputStream, this.cosignatures, 0);
        });
    }
}

