/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.catapult.builders;

import io.nem.symbol.catapult.builders.AddressAliasTransactionBodyBuilder;
import io.nem.symbol.catapult.builders.AddressDto;
import io.nem.symbol.catapult.builders.AliasActionDto;
import io.nem.symbol.catapult.builders.EmbeddedTransactionBuilder;
import io.nem.symbol.catapult.builders.GeneratorUtils;
import io.nem.symbol.catapult.builders.NamespaceIdDto;
import io.nem.symbol.catapult.builders.NetworkTypeDto;
import io.nem.symbol.catapult.builders.PublicKeyDto;
import io.nem.symbol.catapult.builders.Serializer;
import io.nem.symbol.catapult.builders.TransactionTypeDto;
import java.io.DataInputStream;

public class EmbeddedAddressAliasTransactionBuilder
extends EmbeddedTransactionBuilder
implements Serializer {
    private final AddressAliasTransactionBodyBuilder addressAliasTransactionBody;

    protected EmbeddedAddressAliasTransactionBuilder(DataInputStream stream) {
        super(stream);
        try {
            this.addressAliasTransactionBody = AddressAliasTransactionBodyBuilder.loadFromBinary(stream);
        }
        catch (Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    public static EmbeddedAddressAliasTransactionBuilder loadFromBinary(DataInputStream stream) {
        return new EmbeddedAddressAliasTransactionBuilder(stream);
    }

    protected EmbeddedAddressAliasTransactionBuilder(PublicKeyDto signerPublicKey, byte version, NetworkTypeDto network, TransactionTypeDto type, NamespaceIdDto namespaceId, AddressDto address, AliasActionDto aliasAction) {
        super(signerPublicKey, version, network, type);
        GeneratorUtils.notNull(signerPublicKey, "signerPublicKey is null", new Object[0]);
        GeneratorUtils.notNull(version, "version is null", new Object[0]);
        GeneratorUtils.notNull(network, "network is null", new Object[0]);
        GeneratorUtils.notNull(type, "type is null", new Object[0]);
        GeneratorUtils.notNull(namespaceId, "namespaceId is null", new Object[0]);
        GeneratorUtils.notNull(address, "address is null", new Object[0]);
        GeneratorUtils.notNull(aliasAction, "aliasAction is null", new Object[0]);
        this.addressAliasTransactionBody = new AddressAliasTransactionBodyBuilder(namespaceId, address, aliasAction);
    }

    public static EmbeddedAddressAliasTransactionBuilder create(PublicKeyDto signerPublicKey, byte version, NetworkTypeDto network, TransactionTypeDto type, NamespaceIdDto namespaceId, AddressDto address, AliasActionDto aliasAction) {
        return new EmbeddedAddressAliasTransactionBuilder(signerPublicKey, version, network, type, namespaceId, address, aliasAction);
    }

    public NamespaceIdDto getNamespaceId() {
        return this.addressAliasTransactionBody.getNamespaceId();
    }

    public AddressDto getAddress() {
        return this.addressAliasTransactionBody.getAddress();
    }

    public AliasActionDto getAliasAction() {
        return this.addressAliasTransactionBody.getAliasAction();
    }

    @Override
    public int getSize() {
        int size = super.getSize();
        return size += this.addressAliasTransactionBody.getSize();
    }

    @Override
    public AddressAliasTransactionBodyBuilder getBody() {
        return this.addressAliasTransactionBody;
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            byte[] superBytes = super.serialize();
            dataOutputStream.write(superBytes, 0, superBytes.length);
            GeneratorUtils.writeEntity(dataOutputStream, this.addressAliasTransactionBody);
        });
    }
}

