/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.catapult.builders;

import io.nem.symbol.catapult.builders.GeneratorUtils;
import io.nem.symbol.catapult.builders.NetworkTypeDto;
import io.nem.symbol.catapult.builders.PublicKeyDto;
import io.nem.symbol.catapult.builders.Serializer;
import io.nem.symbol.catapult.builders.TransactionTypeDto;
import java.io.DataInputStream;

public class EmbeddedTransactionBuilder
implements Serializer {
    private int size;
    private final int embeddedTransactionHeaderReserved1;
    private final PublicKeyDto signerPublicKey;
    private final int entityBodyReserved1;
    private final byte version;
    private final NetworkTypeDto network;
    private final TransactionTypeDto type;

    protected EmbeddedTransactionBuilder(DataInputStream stream) {
        try {
            this.size = Integer.reverseBytes(stream.readInt());
            this.embeddedTransactionHeaderReserved1 = Integer.reverseBytes(stream.readInt());
            this.signerPublicKey = PublicKeyDto.loadFromBinary(stream);
            this.entityBodyReserved1 = Integer.reverseBytes(stream.readInt());
            this.version = stream.readByte();
            this.network = NetworkTypeDto.loadFromBinary(stream);
            this.type = TransactionTypeDto.loadFromBinary(stream);
        }
        catch (Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    public static EmbeddedTransactionBuilder loadFromBinary(DataInputStream stream) {
        return new EmbeddedTransactionBuilder(stream);
    }

    protected EmbeddedTransactionBuilder(PublicKeyDto signerPublicKey, byte version, NetworkTypeDto network, TransactionTypeDto type) {
        GeneratorUtils.notNull(signerPublicKey, "signerPublicKey is null", new Object[0]);
        GeneratorUtils.notNull(version, "version is null", new Object[0]);
        GeneratorUtils.notNull(network, "network is null", new Object[0]);
        GeneratorUtils.notNull(type, "type is null", new Object[0]);
        this.embeddedTransactionHeaderReserved1 = 0;
        this.signerPublicKey = signerPublicKey;
        this.entityBodyReserved1 = 0;
        this.version = version;
        this.network = network;
        this.type = type;
    }

    public static EmbeddedTransactionBuilder create(PublicKeyDto signerPublicKey, byte version, NetworkTypeDto network, TransactionTypeDto type) {
        return new EmbeddedTransactionBuilder(signerPublicKey, version, network, type);
    }

    public int getStreamSize() {
        return this.size;
    }

    private int getEmbeddedTransactionHeaderReserved1() {
        return this.embeddedTransactionHeaderReserved1;
    }

    public PublicKeyDto getSignerPublicKey() {
        return this.signerPublicKey;
    }

    private int getEntityBodyReserved1() {
        return this.entityBodyReserved1;
    }

    public byte getVersion() {
        return this.version;
    }

    public NetworkTypeDto getNetwork() {
        return this.network;
    }

    public TransactionTypeDto getType() {
        return this.type;
    }

    @Override
    public int getSize() {
        int size = 0;
        size += 4;
        size += 4;
        size += this.signerPublicKey.getSize();
        size += 4;
        ++size;
        size += this.network.getSize();
        return size += this.type.getSize();
    }

    public Serializer getBody() {
        return null;
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            dataOutputStream.writeInt(Integer.reverseBytes(this.getSize()));
            dataOutputStream.writeInt(Integer.reverseBytes(this.getEmbeddedTransactionHeaderReserved1()));
            GeneratorUtils.writeEntity(dataOutputStream, this.signerPublicKey);
            dataOutputStream.writeInt(Integer.reverseBytes(this.getEntityBodyReserved1()));
            dataOutputStream.writeByte(this.getVersion());
            GeneratorUtils.writeEntity(dataOutputStream, this.network);
            GeneratorUtils.writeEntity(dataOutputStream, this.type);
        });
    }
}

