/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.catapult.builders;

import io.nem.symbol.catapult.builders.EmbeddedTransactionBuilder;
import io.nem.symbol.catapult.builders.GeneratorUtils;
import io.nem.symbol.catapult.builders.NetworkTypeDto;
import io.nem.symbol.catapult.builders.PublicKeyDto;
import io.nem.symbol.catapult.builders.Serializer;
import io.nem.symbol.catapult.builders.TransactionTypeDto;
import io.nem.symbol.catapult.builders.TransferTransactionBodyBuilder;
import io.nem.symbol.catapult.builders.UnresolvedAddressDto;
import io.nem.symbol.catapult.builders.UnresolvedMosaicBuilder;
import java.io.DataInputStream;
import java.nio.ByteBuffer;
import java.util.List;

public class EmbeddedTransferTransactionBuilder
extends EmbeddedTransactionBuilder
implements Serializer {
    private final TransferTransactionBodyBuilder transferTransactionBody;

    protected EmbeddedTransferTransactionBuilder(DataInputStream stream) {
        super(stream);
        try {
            this.transferTransactionBody = TransferTransactionBodyBuilder.loadFromBinary(stream);
        }
        catch (Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    public static EmbeddedTransferTransactionBuilder loadFromBinary(DataInputStream stream) {
        return new EmbeddedTransferTransactionBuilder(stream);
    }

    protected EmbeddedTransferTransactionBuilder(PublicKeyDto signerPublicKey, byte version, NetworkTypeDto network, TransactionTypeDto type, UnresolvedAddressDto recipientAddress, List<UnresolvedMosaicBuilder> mosaics, ByteBuffer message) {
        super(signerPublicKey, version, network, type);
        GeneratorUtils.notNull(signerPublicKey, "signerPublicKey is null", new Object[0]);
        GeneratorUtils.notNull(version, "version is null", new Object[0]);
        GeneratorUtils.notNull(network, "network is null", new Object[0]);
        GeneratorUtils.notNull(type, "type is null", new Object[0]);
        GeneratorUtils.notNull(recipientAddress, "recipientAddress is null", new Object[0]);
        GeneratorUtils.notNull(mosaics, "mosaics is null", new Object[0]);
        GeneratorUtils.notNull(message, "message is null", new Object[0]);
        this.transferTransactionBody = new TransferTransactionBodyBuilder(recipientAddress, mosaics, message);
    }

    public static EmbeddedTransferTransactionBuilder create(PublicKeyDto signerPublicKey, byte version, NetworkTypeDto network, TransactionTypeDto type, UnresolvedAddressDto recipientAddress, List<UnresolvedMosaicBuilder> mosaics, ByteBuffer message) {
        return new EmbeddedTransferTransactionBuilder(signerPublicKey, version, network, type, recipientAddress, mosaics, message);
    }

    public UnresolvedAddressDto getRecipientAddress() {
        return this.transferTransactionBody.getRecipientAddress();
    }

    public List<UnresolvedMosaicBuilder> getMosaics() {
        return this.transferTransactionBody.getMosaics();
    }

    public ByteBuffer getMessage() {
        return this.transferTransactionBody.getMessage();
    }

    @Override
    public int getSize() {
        int size = super.getSize();
        return size += this.transferTransactionBody.getSize();
    }

    @Override
    public TransferTransactionBodyBuilder getBody() {
        return this.transferTransactionBody;
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            byte[] superBytes = super.serialize();
            dataOutputStream.write(superBytes, 0, superBytes.length);
            GeneratorUtils.writeEntity(dataOutputStream, this.transferTransactionBody);
        });
    }
}

