/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.catapult.builders;

import io.nem.symbol.catapult.builders.GeneratorUtils;
import io.nem.symbol.catapult.builders.GlobalKeyValueBuilder;
import io.nem.symbol.catapult.builders.Serializer;
import java.io.DataInputStream;
import java.util.List;

public class GlobalKeyValueSetBuilder
implements Serializer {
    private final List<GlobalKeyValueBuilder> keys;

    protected GlobalKeyValueSetBuilder(DataInputStream stream) {
        try {
            byte keyValueCount = stream.readByte();
            this.keys = GeneratorUtils.loadFromBinaryArray(GlobalKeyValueBuilder::loadFromBinary, stream, keyValueCount, 0);
        }
        catch (Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    public static GlobalKeyValueSetBuilder loadFromBinary(DataInputStream stream) {
        return new GlobalKeyValueSetBuilder(stream);
    }

    protected GlobalKeyValueSetBuilder(List<GlobalKeyValueBuilder> keys) {
        GeneratorUtils.notNull(keys, "keys is null", new Object[0]);
        this.keys = keys;
    }

    public static GlobalKeyValueSetBuilder create(List<GlobalKeyValueBuilder> keys) {
        return new GlobalKeyValueSetBuilder(keys);
    }

    public List<GlobalKeyValueBuilder> getKeys() {
        return this.keys;
    }

    @Override
    public int getSize() {
        int size = 0;
        ++size;
        return size += GeneratorUtils.getSumSize(this.keys, 0);
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            dataOutputStream.writeByte((byte)GeneratorUtils.getSize(this.getKeys()));
            GeneratorUtils.writeList(dataOutputStream, this.keys, 0);
        });
    }
}

